% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{as_row_leaves}
\alias{as_row_leaves}
\title{Get leaf matrix}
\usage{
as_row_leaves(term_descendancy_matrix, terms_matrix)
}
\arguments{
\item{term_descendancy_matrix}{Logical term_descendancy_matrix, dimensions symmetrically labelled by terms, and where by a cell value of TRUE indicates that the row is the ancestor of the column term (in the sense of the DAG structure of the HPO)}

\item{terms_matrix}{The character matrix of HPO terms}
}
\value{
Logical matrix the same dimensions as the terms_matrix which indicates whethere each element is a leaf or not
}
\description{
Procure logical matrix from character matrix of ontological terms, indicating whether each element is a leaf in the context of the row. Typically used to map the sampled vectors of the ontological parameter phi from the \code{\link{sim_reg}} procedure.
}
\examples{
library(ontologyIndex)
data(hpo)
as_row_leaves(
	get_term_descendancy_matrix(hpo, c("HP:0001873", "HP:0001872")),
	matrix(c("HP:0001873","HP:0001872","HP:0001873","HP:0001872"),2,2)
)
}

