% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dist_spde.R
\name{make_mesh}
\alias{make_mesh}
\title{Make an R-INLA mesh based off a grid}
\usage{
make_mesh(
  grid = make_grid(),
  max.edge = 50,
  bound.outer = 150,
  cutoff = 10,
  offset = c(max.edge, bound.outer),
  ...
)
}
\arguments{
\item{grid}{grid object to make a mesh of}

\item{max.edge}{The largest allowed triangle edge length. One or two values. This is passed to inla.mesh.2d}

\item{bound.outer}{The optional outer extension value given to offset.}

\item{cutoff}{Minimum distance allowed between points}

\item{offset}{The automatic extension distance given to inla.mesh.2d}

\item{...}{Other options to pass to inla.mesh.2d}
}
\value{
Returns an object of class \code{inla.mesh}.
}
\description{
This will make a mesh based off a given grid. Ideally the mesh
construction and validation should be done by hand, but this exists
for convenience. Meshes are used for sim_ays_covar_spde. The defaults
are designed for the default grid. Just a basic interface between the grid and inla.mesh.2d.
}
\examples{

\donttest{

if (requireNamespace("INLA")) {
  basic_mesh <- make_mesh()
  plot(basic_mesh)
}

}

}
