% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss.ceDiag.R
\name{ss.ceDiag}
\alias{ss.ceDiag}
\title{Cause and Effect Diagram}
\usage{
ss.ceDiag(
  effect,
  causes.gr,
  causes,
  main = "Six Sigma Cause-and-effect Diagram",
  sub,
  ss.col = c("#666666", "#BBBBBB", "#CCCCCC", "#DDDDDD", "#EEEEEE")
)
}
\arguments{
\item{effect}{A short character string that represents the effect we want to analyse.}

\item{causes.gr}{A vector of characters that represents the causes groups.}

\item{causes}{A vector with lists that represents the individual causes for each}

\item{main}{Main title for the diagram}

\item{sub}{Subtitle for the diagram (recommended the Six Sigma project name)}

\item{ss.col}{A vector of colors for a personalized drawing. At least five colors,
sorted by descendant intensity}
}
\value{
A drawing of the causes and effect with "fish-bone" shape
}
\description{
Represents a Cause and Effect Diagram by cause group.
}
\details{
The default value for ss.col is c("#666666", "#BBBBBB", "#CCCCCC", "#DDDDDD",
  "#EEEEEE"), a grayscale style. You can pass any accepted colour string.
}
\note{
The cause and effect diagram is also known as "Ishikawa diagram", and
  has been widely used in Quality Management. It is one of the Seven
  Basic Tools of Quality.
}
\examples{
effect <- "Flight Time"
causes.gr <- c("Operator", "Environment", "Tools", "Design", 
  "Raw.Material", "Measure.Tool")
causes <- vector(mode = "list", length = length(causes.gr))
causes[1] <- list(c("operator #1", "operator #2", "operator #3"))
causes[2] <- list(c("height", "cleaning"))
causes[3] <- list(c("scissors", "tape"))
causes[4] <- list(c("rotor.length", "rotor.width2", "paperclip"))
causes[5] <- list(c("thickness", "marks"))
causes[6] <- list(c("calibrate", "model"))
ss.ceDiag(effect, causes.gr, causes, sub = "Paper Helicopter Project")

}
\references{
Cano, Emilio L., Moguerza, Javier M. and Redchuk, Andres. 2012.
\emph{Six Sigma with {R}. Statistical Engineering for Process
  Improvement}, Use R!, vol. 36. Springer, New York.
  \url{https://www.springer.com/gp/book/9781461436515}.\cr

Wikipedia, \url{https://en.wikipedia.org/wiki/Ishikawa_diagram}
}
\seealso{
\code{\link{ss.pMap}}
}
\author{
EL Cano
}
\keyword{cause-and-effect}
