% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descritive_statistics_SlidingWindows.R
\name{descritive_statsistics_SlidingWindows}
\alias{descritive_statsistics_SlidingWindows}
\title{Descritive statistics with sliding windows.}
\usage{
descritive_statsistics_SlidingWindows(
  y,
  w,
  skewness = c("moment", "sample", "fisher"),
  kurtosis = c("moment", "sample", "fisher", "excess", "sample_excess")
)
}
\arguments{
\item{y}{A vector containing univariate time series.}

\item{w}{An integer value indicating the window size \eqn{w < length(y)}.
If \eqn{w = length(y)}, will be computed the function will not slide.}

\item{skewness}{A non-numeric value. See PerformanceAnalytics package.}

\item{kurtosis}{A non-numeric value. See PerformanceAnalytics package.}
}
\value{
A list containing "w", "min","max","mean", "median", "standard deviation","skewness" and "kurtosis".
}
\description{
This function generates descriptive statistics of a univariate time series with sliding windows approach.
}
\details{
This function include following measures: min, max, mean, median, standard deviation, skewness and kurtosis.
}
\examples{
y <- rnorm(1000)
descritive_statsistics_SlidingWindows(rnorm(100), 99, skewness="moment", kurtosis="moment")

}
\references{
Guedes, E.F. Modelo computacional para análise de movimentos e co-movimentos de mercados financeiros, Ph.D. thesis, Programa de Pós-graduação em Modelagem Computacional e Tecnologia Industrial. Centro Universitário Senai Cimatec, 2019.
}
