% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhodcca_SlidingWindows.R
\name{rhodcca_SlidingWindows}
\alias{rhodcca_SlidingWindows}
\title{Detrended Cross-Correlation Coefficient with sliding windows.}
\usage{
rhodcca_SlidingWindows(x, y, w, k, nu)
}
\arguments{
\item{x}{A vector containing univariate time series.}

\item{y}{A vector containing univariate time series.}

\item{w}{An integer value indicating the window size \eqn{w < length(y)}.
If \eqn{w = length(y)}, will be computed the function will not slide.}

\item{k}{An integer value indicating the boundary of the division \eqn{(N/k)}.
The smallest value of \eqn{k} is \eqn{4}.}

\item{nu}{An integer value. See DCCA package.}
}
\value{
A list containing "w", "timescale", "rhodcca".
}
\description{
This function generates Detrended Cross-Correlation Coefficient of
two time series with sliding windows approach.
}
\details{
This function include following measures:

    w, timescale, rhodcca
}
\examples{
x <- rnorm(100)
y <- rnorm(100)
rhodcca_SlidingWindows(x,y,w=99,k=10,nu=0)

}
\references{
GUEDES, E.F.; ZEBENDE, G.F. DCCA cross-correlation coefficient with sliding windows approach. PHYSICA A, v.527, p.121286, 2019.

ZEBENDE, G.F. DCCA cross-correlation coefficient: Quantifying level of cross-correlation, Physica A, v. 390, n. 4, p. 614-618, 2011.
}
