% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMissing.R
\name{allMissing}
\alias{allMissing}
\title{Identifies missing rows or columns in a data frame or matrix}
\usage{
allMissing(dframe, byRow = TRUE)
}
\arguments{
\item{dframe}{A data frame or a matrix}

\item{byRow}{\code{= TRUE} will identify rows that have all missing values.
\code{= FALSE} identifies entire missing columns}
}
\value{
A logical vector that is true if all the elements in the
corresponding row (or column) are NA's.
}
\description{
Indicates which rows or columns in a data frame or matrix are completely
missing (all values are NA's).
}
\examples{

# Start off with a simple data frame that has a few missing values
d1 <- data.frame(x=c(3,4,NA,1,10,NA), y=c(NA,"b","c","d","e",NA))
d1

# Identify rows were the entire row is missing
allMissing(d1)

# Only removes rows where all the values are missing
d1[!allMissing(d1),]

# All missing can also be used to identify if any of the
# columns are 'all missing'
d2 <- data.frame(x=c(rnorm(3), NA, rnorm(6)), y=rep(NA,10), z=letters[1:10])
d2

# Look for columns that are all missing
allMissing(d2, byRow=FALSE)

# Remove columns where all the values are missing
d2[,!allMissing(d2, byRow = FALSE)]

}
\author{
Landon Sego
}
\seealso{
\code{\link{complete.cases}}
}
\keyword{misc}

