% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-classes.R
\name{parse_family}
\alias{parse_family}
\title{Parse components of a "family-level" taxon name}
\usage{
parse_family(family, column_metadata = TRUE, flat = TRUE)
}
\arguments{
\item{family}{character. vector of taxonomic families, e.g. \code{"fine-loamy, mixed, semiactive, mesic ultic haploxeralfs"}}

\item{column_metadata}{logical. include parsed NASIS physical column names and values from family taxon components? Default: \code{TRUE} requires soilDB package.}

\item{flat}{logical Default: \code{TRUE} to return concatenated family-level classes for \code{"taxminalogy"} and \code{"taxfamother"}? Alternately, if \code{FALSE}, list columns are returned.}
}
\value{
a \code{data.frame} containing column names: \code{"family"} (input), \code{"subgroup"} (parsed taxonomic subgroup), \code{"subgroup_code"} (letter code for subgroup), \code{"class_string"} (comma-separated family classes), \code{"classes_split"} (split \code{class_string} vector stored as \code{list} column).

In addition, the following column names are identified and returned based on NASIS (National Soil Information System) metadata (via soilDB package):
\itemize{
\item \code{"taxpartsize"}, \code{"taxpartsizemod"}, \code{"taxminalogy"}, \code{"taxceactcl"}, \code{"taxreaction"}, \code{"taxtempcl"}, \code{"taxfamhahatmatcl"}, \code{"taxfamother"}, \code{"taxsubgrp"}, \code{"taxgreatgroup"}, \code{"taxsuborder"}, \code{"taxorder"}
}
}
\description{
Parse components of a "family-level" taxon name
}
\examples{
if (requireNamespace('soilDB')) {
  families <- c("fine, kaolinitic, thermic typic kanhapludults",
                "fine-loamy, mixed, semiactive, mesic ultic haploxeralfs",
                "euic, thermic typic haplosaprists",
                "coarse-loamy, mixed, active, mesic aquic dystrudepts")

  # inspect parsed list result
  str(parse_family(families))
}
}
