% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilTaxonomyLevels.R
\name{SoilTaxonomyLevels}
\alias{SoilTaxonomyLevels}
\alias{SoilMoistureRegimeLevels}
\alias{SoilTemperatureRegimeLevels}
\title{Get (Ordered) Factors based on Soil Taxonomy Key position}
\usage{
SoilTaxonomyLevels(
  level = c("order", "suborder", "greatgroup", "subgroup"),
  as.is = FALSE,
  ordered = TRUE
)

SoilMoistureRegimeLevels(as.is = FALSE, ordered = TRUE)

SoilTemperatureRegimeLevels(as.is = FALSE, ordered = TRUE)
}
\arguments{
\item{level}{One of: \code{"order"}, \code{"suborder"}, \code{"greatgroup"}, \code{"subgroup"}}

\item{as.is}{Return character labels rather than an (ordered) factor? Default: \code{FALSE}}

\item{ordered}{Create an ordinal factor? Default: \code{TRUE}}
}
\value{
an (ordered) factor or character vector (when \code{as.is=TRUE})
}
\description{
Get (Ordered) Factors based on Soil Taxonomy Key position
}
\examples{

SoilTaxonomyLevels("order")

SoilTaxonomyLevels("order", ordered = FALSE)

SoilTaxonomyLevels("order", as.is = TRUE)

SoilTaxonomyLevels("suborder")

}
