% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-adat.R
\name{read_adat}
\alias{read_adat}
\alias{read.adat}
\alias{is.soma_adat}
\title{Read (Load) SomaLogic ADATs}
\usage{
read_adat(file, debug = FALSE, verbose = getOption("verbose"), ...)

read.adat(file, debug = FALSE, verbose = getOption("verbose"), ...)

is.soma_adat(x)
}
\arguments{
\item{file}{Character. The elaborated path and file name of the \verb{*.adat}
file to be loaded into an R workspace.}

\item{debug}{Logical. Used for debugging and development of an ADAT that
fails to load, particularly out-of-spec, poorly modified, or legacy ADATs.}

\item{verbose}{Logical. Should the function call be run in \emph{verbose}
mode, printing relevant diagnostic call information to the console.}

\item{...}{Additional arguments passed ultimately to
\code{\link[=read.delim]{read.delim()}}, or additional arguments passed to either
other S3 print or summary methods as required by those generics.}

\item{x}{An \code{R} object to test.}
}
\value{
A \code{data.frame}-like object of class \code{soma_adat}
consisting of SomaLogic RFU (feature) data and clinical meta data as
columns, and samples as rows. Row names are labeled with the unique ID
"SlideId_Subarray" concatenation. The sections of the ADAT header (e.g.,
"Header.Meta", "Col.Meta", ...) are stored as attributes (e.g.
\code{attributes(x)$Header.Meta}).

Logical. Whether \code{x} inherits from class \code{soma_adat}.
}
\description{
The parse and load a \verb{*.adat} file as a \code{data.frame}-like object into
an R workspace environment. The class of the returned object is
a \code{soma_adat} object.

\code{\link[=read.adat]{read.adat()}} is a convenient backward compatibility alias for
\code{\link[=read_adat]{read_adat()}} to enable use of older versions of \code{SomaDataIO}. It will likely
never go away completely, but you strongly encouraged to shift your code
to use \code{\link[=read_adat]{read_adat()}}.

\code{\link[=is.soma_adat]{is.soma_adat()}} checks whether an object is of class \code{soma_adat}.
See \code{\link[=inherits]{inherits()}}.
}
\examples{
f <- system.file("extdata", "example_data10.adat",
                 package = "SomaDataIO", mustWork = TRUE)
my_adat <- read_adat(f)

is.soma_adat(my_adat)
}
\seealso{
\code{\link[=read.delim]{read.delim()}}

Other IO: 
\code{\link{loadAdatsAsList}()},
\code{\link{parseHeader}()},
\code{\link{soma_adat}},
\code{\link{write_adat}()}
}
\author{
Stu Field
}
\concept{IO}
