% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\name{packages}
\alias{packages}
\alias{simList-accessors-packages}
\alias{packages,ANY-method}
\title{Get module or simulation package dependencies}
\usage{
packages(sim, modules, paths, filenames, envir, clean = FALSE, ...)

\S4method{packages}{ANY}(sim, modules, paths, filenames, envir, clean = FALSE, ...)
}
\arguments{
\item{sim}{A \code{simList} object.}

\item{modules}{Character vector, specifying the name or
vector of names of module(s)}

\item{paths}{Character vector, specifying the name or
vector of names of paths(s) for those modules. If path not specified,
it will be taken from getOption("spades.modulePath"), which is set
with \code{setPaths})}

\item{filenames}{Character vector specifying filenames of modules (i.e.
combined path & module. If this is specified, then \code{modules} and
\code{path} are ignored.}

\item{envir}{Optional environment in which to store parsed code. This may be
useful if the same file is being parsed multiple times. This
function will check in that envir for the parsed file before
parsing again. If the \code{envir} is transient, then this will
have no effect.}

\item{clean}{Optional logical. If \code{TRUE}, it will scrub any references to
github repositories, e.g., "PredictiveEcology/reproducible" will be
returned as "reproducible"}

\item{...}{All \code{simInit} parameters.}
}
\value{
A sorted character vector of package names.
}
\description{
Get module or simulation package dependencies
}
\seealso{
Other functions to access elements of a 'simList' object: 
\code{\link{.addDepends}()},
\code{\link{doEvent.checkpoint}()},
\code{\link{envir}()},
\code{\link{events}()},
\code{\link{globals}()},
\code{\link{inputs}()},
\code{\link{modules}()},
\code{\link{objs}()},
\code{\link{params}()},
\code{\link{paths}()},
\code{\link{progressInterval}()},
\code{\link{times}()}
}
\author{
Alex Chubaty & Eliot McIntire
}
\concept{functions to access elements of a 'simList' object}
