% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\name{inputs}
\alias{inputs}
\alias{simList-accessors-inout}
\alias{inputs,simList-method}
\alias{inputs<-}
\alias{inputs<-,simList-method}
\alias{inputArgs}
\alias{inputArgs,simList-method}
\alias{inputArgs<-}
\alias{inputArgs<-,simList-method}
\title{Simulation inputs}
\usage{
inputs(sim)

\S4method{inputs}{simList}(sim)

inputs(sim) <- value

\S4method{inputs}{simList}(sim) <- value

inputArgs(sim)

\S4method{inputArgs}{simList}(sim)

inputArgs(sim) <- value

\S4method{inputArgs}{simList}(sim) <- value
}
\arguments{
\item{sim}{A \code{simList} object from which to extract element(s) or
in which to replace element(s).}

\item{value}{The object to be stored at the slot. See Details.}
}
\value{
Returns or sets the value(s) of the \code{input} or \code{output} slots
in the \code{simList} object.
}
\description{
Accessor functions for the \code{inputs} slots in a \code{simList} object.
}
\details{
These functions are one of three mechanisms to add the information about which input files
to load in a \code{spades} call.
\enumerate{
\item As arguments to a \code{simInit} call. Specifically, \code{inputs} or \code{outputs}.
See \code{?simInit}.
\item With the \code{outputs(simList)} function call.
\item By adding a function called \code{.inputObjects} inside a module, which will be executed
during the \code{simInit} call. This last way is the most "modular" way to create
default data sets for your model.
}

See below for more details.
}
\section{inputs function or argument in \code{simInit}}{


\code{inputs} accepts a data.frame, with up to 7 columns.
Columns are:

\tabular{ll}{
\code{file} \tab required, a character string indicating the file path. There is no
default.\cr

\code{objectName} \tab optional, character string indicating the name of the object
that the loaded file will be assigned to in the \code{simList}. This object
can therefore be accessed with \code{sim$xxx} in any module, where
\code{objectName = "xxx"}. Defaults to the filename without file extension or
directory information.\cr

\code{fun} \tab optional, a character string indicating the function to use to
load that file. Defaults to the known extensions in \code{SpaDES} (found by
examining \code{.fileExtensions()}). The \code{package} and \code{fun} can be
jointly specified here as \code{"packageName::functionName"}, e.g.,
\code{"raster::raster"}.\cr

\code{package} \tab optional character string indicating the package in
which to find the \code{fun});\cr

\code{loadTime} \tab optional numeric, indicating when in simulation time the file
should be loaded. The default is the highest priority at \code{start(sim)},
i.e., at the very start. \cr

\code{interval} \tab optional numeric, indicating at what interval should this same
exact file  be reloaded from disk, e.g,. 10 would mean every 10 time units. The
default is NA or no interval, i.e, load the file only once as described in
\code{loadTime} \cr

\code{arguments} \tab is a list of lists of named arguments, one list for each
\code{fun}. For example, if \code{fun="raster"}, \code{arguments = list(native = TRUE)}
will pass the argument "native = TRUE" to raster.  If there is only one list,
then it is assumed to apply to all files and will be recycled as per normal R
rules of recycling for each \code{fun}.\cr
}

Currently, only \code{file} is required. All others will be filled with defaults
if not specified.

See the modules vignette for more details (\code{browseVignettes("SpaDES.core")}).
}

\section{\code{.inputObjects} function placed inside module}{


Any code placed inside a function called \code{.inputObjects} will be run during
\code{simInit()} for the purpose of creating any objects required by this module,
i.e., objects  identified in the \code{inputObjects} element of \code{defineModule}.
This is useful if there is something required before simulation to produce the module
object dependencies, including such things as downloading default datasets, e.g.,
\code{downloadData('LCC2005', modulePath(sim))}.
Nothing should be created here that does not create an named object in \code{inputObjects}.
Any other initiation procedures should be put in the "init" eventType of the doEvent function.
Note: the module developer can use 'sim$.userSuppliedObjNames' inside the function to
selectively skip unnecessary steps because the user has provided those inputObjects in the
simInit call. e.g., the following code would look to see if the user had passed \code{defaultColor}
into during \code{simInit}. If the user had done this, then this function would not override
that value with 'red'. If the user has not passed in a value for \code{defaultColor}, then
the module will get it here:

\code{if (!('defaultColor' \%in\% sim$.userSuppliedObjNames)) \{
 sim$defaultColor <- 'red'
\}}
}

\examples{
#######################
# inputs
#######################

# Start with a basic empty simList
sim <- simInit()

test <- 1:10
library(igraph) # for \%>\%
library(reproducible) # for checkPath
tmpdir <- file.path(tempdir(), "inputs") \%>\% checkPath(create = TRUE)
tmpFile <- file.path(tmpdir, "test.rds")
saveRDS(test, file = tmpFile)
inputs(sim) <- data.frame(file = tmpFile) # using only required column, "file"
inputs(sim) # see that it is not yet loaded, but when it is scheduled to be loaded
simOut <- spades(sim)
inputs(simOut) # confirm it was loaded
simOut$test

# can put data.frame for inputs directly inside simInit call
allTifs <- dir(system.file("maps", package = "quickPlot"),
               full.names = TRUE, pattern = "tif")

# next: .objectNames are taken from the filenames (without the extension)
# This will load all 5 tifs in the SpaDES sample directory, using
#   the raster fuction in the raster package, all at time = 0
if (require("rgdal", quietly = TRUE)) {
  sim <- simInit(
    inputs = data.frame(
      files = allTifs,
      functions = "raster",
      package = "raster",
      loadTime = 0,
      stringsAsFactors = FALSE)
    )

  ##############################
  #A fully described inputs object, including arguments:
  files <- dir(system.file("maps", package = "quickPlot"),
               full.names = TRUE, pattern = "tif")
  # arguments must be a list of lists. This may require I() to keep it as a list
  #   once it gets coerced into the data.frame.
  arguments = I(rep(list(native = TRUE), length(files)))
  filelist = data.frame(
     objectName = paste0("Maps", 1:5),
     files = files,
     functions = "raster::raster",
     arguments = arguments,
     loadTime = 0,
     intervals = c(rep(NA, length(files) - 1), 10)
  )
  inputs(sim) <- filelist
  spades(sim)
}

# Example showing loading multiple objects from global environment onto the
#   same object in the simList, but at different load times
a1 <- 1
a2 <- 2
# Note arguments must be a list of NROW(inputs), with each element itself being a list,
#  which is passed to do.call(fun[x], arguments[[x]]), where x is row number, one at a time
args <- lapply(1:2, function(x) {
               list(x = paste0("a", x),
                    envir = environment()) # may be necessary to specify in which envir a1, a2
                                           # are located, if not in an interactive sessino
               })
inputs <- data.frame(objectName = "a", loadTime = 1:2, fun = "base::get", arguments = I(args))
a <- simInit(inputs = inputs, times = list(start = 0, end = 1))
a <- spades(a)
identical(a1, a$a)

end(a) <- 3
a <- spades(a) # different object (a2) loaded onto a$a
identical(a2, a$a)

# Clean up after
unlink(tmpdir, recursive = TRUE)
}
\seealso{
\code{\link[=SpaDES.core-package]{SpaDES.core-package()}}, specifically the section 1.2.2 on loading and saving.

Other functions to access elements of a 'simList' object: 
\code{\link{.addDepends}()},
\code{\link{doEvent.checkpoint}()},
\code{\link{envir}()},
\code{\link{events}()},
\code{\link{globals}()},
\code{\link{modules}()},
\code{\link{objs}()},
\code{\link{packages}()},
\code{\link{params}()},
\code{\link{paths}()},
\code{\link{progressInterval}()},
\code{\link{times}()}
}
\concept{functions to access elements of a 'simList' object}
