% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/module-template.R
\docType{methods}
\name{openModules}
\alias{openModules}
\alias{openModules,character,character-method}
\alias{openModules,character,missing-method}
\alias{openModules,missing,character-method}
\alias{openModules,missing,missing-method}
\title{Open all modules nested within a base directory}
\usage{
openModules(name, path)

\S4method{openModules}{character,character}(name, path)

\S4method{openModules}{missing,missing}()

\S4method{openModules}{missing,character}(path)

\S4method{openModules}{character,missing}(name)
}
\arguments{
\item{name}{Character vector with names of modules to open. If missing, then all modules
will be opened within the basedir.}

\item{path}{Character string of length 1. The base directory within which there are only
module subdirectories.}
}
\value{
Nothing is returned. All file are open via \code{file.edit}.
}
\description{
This is just a convenience wrapper for openning several modules at once, recursively.
A module is defined as any file that ends in \code{.R} or \code{.r} and has a
directory name identical to its filename. Thus, this must be case sensitive.
}
\examples{
\dontrun{openModules("~\\SpaDESModules")}
}
\author{
Eliot McIntire
}

