% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkpoint.R
\docType{methods}
\name{cache}
\alias{cache}
\alias{cache,ANY-method}
\title{Cache method for simList class objects}
\usage{
cache(cacheRepo = NULL, FUN, ..., notOlderThan = NULL)

\S4method{cache}{ANY}(cacheRepo = NULL, FUN, ..., notOlderThan = NULL)
}
\arguments{
\item{cacheRepo}{A repository used for storing cached objects.}

\item{FUN}{A function to be called.}

\item{...}{Arguments of \code{FUN} function .}

\item{notOlderThan}{load an artifact from the database only if it was created after notOlderThan.}
}
\value{
Identical to \code{\link[archivist]{cache}}
}
\description{
Because the \code{simList} has an environment as one of its slots,
the caching mechanism of the archivist package does not work.
Here, we make a slight tweak to the \code{cache} function.
Specifically, we remove all elements that have an environment as part of
their attributes.
This is generally functions that are loaded from the modules,
but also the \code{.envir} slot in the \code{simList}.
Thus, only non-function objects are used as part of the \code{digest} call
in the \code{digest} package (used internally in the \code{cache} function).
}
\examples{
\dontrun{
times <- list(start=0, end=10)
params <- list(dummy = 1)
mySim <- simInit(times = times, params = params)
if (require(archivist)) {
  archivist::createLocalRepo(paths(mySim)$cachePath)
  system.time(outSim <- cache(paths(mySim)$cachePath, spades, sim = mySim))

  # will be cached now, to be sure inputs are identical,
  #   mySim should be put back to original state
  mySim <- simInit(times = times)
  system.time(outSim <- cache(paths(mySim)$cachePath, spades, sim = mySim))
  # compare
  system.time(outSim2 <- spades(mySim))
}
}

}
\author{
Eliot McIntire
}
\seealso{
\code{\link[archivist]{cache}}.
}

