% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spades-package.R
\docType{package}
\name{SpaDES-package}
\alias{SpaDES}
\alias{SpaDES-package}
\title{Categorized overview of the \code{SpaDES} package}
\description{
\if{html}{\figure{SpaDES.png}{options: width=100 alt="SpaDES logo" align="right"}}
\if{latex}{\figure{SpaDES.png}{options: width=0.5in}}

Metapackage for implementing a variety of event-based models, with a focus on
spatially explicit models. These include raster-based, event-based, and
agent-based models. The core simulation components (provided by \code{SpaDES.core})
are built upon a discrete event simulation (DES; see Matloff (2011) ch 7.8.3
\url{https://nostarch.com/artofr.htm}) framework that facilitates
modularity, and easily enables the user to include additional functionality by
running user-built simulation modules (see also \code{SpaDES.tools}).
Included are numerous tools to visualize rasters and other maps (via \code{quickPlot}),
and caching methods for reproducible simulations (via \code{reproducible}).
Additional functionality is provided by the \code{SpaDES.addins} and
\code{SpaDES.shiny} packages (see below).

Bug reports:
\itemize{
  \item \code{quickPlot} package:
        \url{https://github.com/PredictiveEcology/quickPlot/issues}
  \item \code{reproducible} package:
        \url{https://github.com/PredictiveEcology/reproducible/issues}
  \item \code{SpaDES.addins} package:
        \url{https://github.com/PredictiveEcology/SpaDES.addins/issues}
  \item \code{SpaDES.core} package:
        \url{https://github.com/PredictiveEcology/SpaDES.core/issues}
  \item \code{SpaDES.shiny} package:
        \url{https://github.com/PredictiveEcology/SpaDES.shiny/issues}
  \item \code{SpaDES.tools} package:
        \url{https://github.com/PredictiveEcology/SpaDES.tools/issues}
}

Module repository: \url{https://github.com/PredictiveEcology/SpaDES-modules}

Wiki: \url{https://github.com/PredictiveEcology/SpaDES/wiki}

------------------------------------------------------------------------------------------
}
\section{The \code{SpaDES.core} package}{


The core discrete event simulation framework.
See \code{\link{SpaDES.core}{SpaDES.core-package}}, and the vignettes therein
(\code{browseVignettes()}).

------------------------------------------------------------------------------------------
}

\section{The \code{SpaDES.tools} package}{


Additional utilities for developing ecological simulation models.
See \code{\link{SpaDES.tools}{SpaDES.tools-package}}.

------------------------------------------------------------------------------------------
}

\section{The \code{SpaDES.addins} package}{


A set of RStudio addins to assist with \code{SpaDES} module development.

------------------------------------------------------------------------------------------
}

\section{The \code{SpaDES.shiny} package}{


Utilities for developing and running \code{shiny}-based app interfaces to
\code{SpaDES} simulations.

------------------------------------------------------------------------------------------
}

\section{The \code{quickPlot} package}{


The core \code{SpaDES} plotting engine, build upon speed and modularity.

------------------------------------------------------------------------------------------
}

\section{The \code{reproducible} package}{


Provides several aspects of reproducible simulations, including simulation caching.
}

\seealso{
Useful links:
\itemize{
  \item \url{http://spades.predictiveecology.org}
  \item \url{https://github.com/PredictiveEcology/SpaDES}
  \item Report bugs at \url{https://github.com/PredictiveEcology/SpaDES/issues}
}

}
\author{
\strong{Maintainer}: Alex M Chubaty \email{alex.chubaty@gmail.com}

Authors:
\itemize{
  \item Eliot J B McIntire \email{eliot.mcintire@canada.ca}
}

Other contributors:
\itemize{
  \item Yong Luo \email{yluo1@lakeheadu.ca} [contributor]
  \item Steve Cumming \email{Steve.Cumming@sbf.ulaval.ca} [contributor]
  \item Her Majesty the Queen in Right of Canada, as represented by the Minister of Natural Resources Canada [copyright holder]
}

}
