% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\docType{methods}
\name{insertInto}
\alias{insertInto}
\alias{insertInto}
\alias{insertInto,SparkDataFrame,character-method}
\title{insertInto}
\usage{
insertInto(x, tableName, ...)

\S4method{insertInto}{SparkDataFrame,character}(x, tableName,
  overwrite = FALSE)
}
\arguments{
\item{x}{a SparkDataFrame.}

\item{tableName}{a character vector containing the name of the table.}

\item{...}{further arguments to be passed to or from other methods.
the existing rows in the table.}

\item{overwrite}{a logical argument indicating whether or not to overwrite.}
}
\description{
Insert the contents of a SparkDataFrame into a table registered in the current SparkSession.
}
\note{
insertInto since 1.4.0
}
\examples{
\dontrun{
sparkR.session()
df <- read.df(path, "parquet")
df2 <- read.df(path2, "parquet")
createOrReplaceTempView(df, "table1")
insertInto(df2, "table1", overwrite = TRUE)
}
}
\seealso{
Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{arrange}},
  \code{\link{as.data.frame}}, \code{\link{attach}},
  \code{\link{cache}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{dapplyCollect}},
  \code{\link{dapply}}, \code{\link{describe}},
  \code{\link{dim}}, \code{\link{distinct}},
  \code{\link{dropDuplicates}}, \code{\link{dropna}},
  \code{\link{drop}}, \code{\link{dtypes}},
  \code{\link{except}}, \code{\link{explain}},
  \code{\link{filter}}, \code{\link{first}},
  \code{\link{gapplyCollect}}, \code{\link{gapply}},
  \code{\link{getNumPartitions}}, \code{\link{group_by}},
  \code{\link{head}}, \code{\link{histogram}},
  \code{\link{intersect}}, \code{\link{isLocal}},
  \code{\link{join}}, \code{\link{limit}},
  \code{\link{merge}}, \code{\link{mutate}},
  \code{\link{ncol}}, \code{\link{nrow}},
  \code{\link{persist}}, \code{\link{printSchema}},
  \code{\link{randomSplit}}, \code{\link{rbind}},
  \code{\link{registerTempTable}}, \code{\link{rename}},
  \code{\link{repartition}}, \code{\link{sample}},
  \code{\link{saveAsTable}}, \code{\link{schema}},
  \code{\link{selectExpr}}, \code{\link{select}},
  \code{\link{showDF}}, \code{\link{show}},
  \code{\link{storageLevel}}, \code{\link{str}},
  \code{\link{subset}}, \code{\link{take}},
  \code{\link{union}}, \code{\link{unpersist}},
  \code{\link{withColumn}}, \code{\link{with}},
  \code{\link{write.df}}, \code{\link{write.jdbc}},
  \code{\link{write.json}}, \code{\link{write.orc}},
  \code{\link{write.parquet}}, \code{\link{write.text}}
}
