% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib.R
\docType{methods}
\name{spark.mlp}
\alias{spark.mlp}
\alias{spark.mlp}
\alias{spark.mlp,SparkDataFrame,formula-method}
\alias{predict,MultilayerPerceptronClassificationModel-method}
\alias{summary,MultilayerPerceptronClassificationModel-method}
\alias{write.ml,MultilayerPerceptronClassificationModel,character-method}
\title{Multilayer Perceptron Classification Model}
\usage{
spark.mlp(data, formula, ...)

\S4method{spark.mlp}{SparkDataFrame,formula}(data, formula, layers,
  blockSize = 128, solver = "l-bfgs", maxIter = 100, tol = 1e-06,
  stepSize = 0.03, seed = NULL, initialWeights = NULL)

\S4method{predict}{MultilayerPerceptronClassificationModel}(object, newData)

\S4method{summary}{MultilayerPerceptronClassificationModel}(object)

\S4method{write.ml}{MultilayerPerceptronClassificationModel,character}(object,
  path, overwrite = FALSE)
}
\arguments{
\item{data}{a \code{SparkDataFrame} of observations and labels for model fitting.}

\item{formula}{a symbolic description of the model to be fitted. Currently only a few formula
operators are supported, including '~', '.', ':', '+', and '-'.}

\item{...}{additional arguments passed to the method.}

\item{layers}{integer vector containing the number of nodes for each layer.}

\item{blockSize}{blockSize parameter.}

\item{solver}{solver parameter, supported options: "gd" (minibatch gradient descent) or "l-bfgs".}

\item{maxIter}{maximum iteration number.}

\item{tol}{convergence tolerance of iterations.}

\item{stepSize}{stepSize parameter.}

\item{seed}{seed parameter for weights initialization.}

\item{initialWeights}{initialWeights parameter for weights initialization, it should be a
numeric vector.}

\item{object}{a Multilayer Perceptron Classification Model fitted by \code{spark.mlp}}

\item{newData}{a SparkDataFrame for testing.}

\item{path}{the directory where the model is saved.}

\item{overwrite}{overwrites or not if the output path already exists. Default is FALSE
which means throw exception if the output path exists.}
}
\value{
\code{spark.mlp} returns a fitted Multilayer Perceptron Classification Model.

\code{predict} returns a SparkDataFrame containing predicted labeled in a column named
"prediction".

\code{summary} returns summary information of the fitted model, which is a list.
        The list includes \code{numOfInputs} (number of inputs), \code{numOfOutputs}
        (number of outputs), \code{layers} (array of layer sizes including input
        and output layers), and \code{weights} (the weights of layers).
        For \code{weights}, it is a numeric vector with length equal to the expected
        given the architecture (i.e., for 8-10-2 network, 112 connection weights).
}
\description{
\code{spark.mlp} fits a multi-layer perceptron neural network model against a SparkDataFrame.
Users can call \code{summary} to print a summary of the fitted model, \code{predict} to make
predictions on new data, and \code{write.ml}/\code{read.ml} to save/load fitted models.
Only categorical data is supported.
For more details, see
\href{http://spark.apache.org/docs/latest/ml-classification-regression.html}{
  Multilayer Perceptron}
}
\note{
spark.mlp since 2.1.0

predict(MultilayerPerceptronClassificationModel) since 2.1.0

summary(MultilayerPerceptronClassificationModel) since 2.1.0

write.ml(MultilayerPerceptronClassificationModel, character) since 2.1.0
}
\examples{
\dontrun{
df <- read.df("data/mllib/sample_multiclass_classification_data.txt", source = "libsvm")

# fit a Multilayer Perceptron Classification Model
model <- spark.mlp(df, label ~ features, blockSize = 128, layers = c(4, 3), solver = "l-bfgs",
                   maxIter = 100, tol = 0.5, stepSize = 1, seed = 1,
                   initialWeights = c(0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 9, 9, 9, 9, 9))

# get the summary of the model
summary(model)

# make predictions
predictions <- predict(model, df)

# save and load the model
path <- "path/to/model"
write.ml(model, path)
savedModel <- read.ml(path)
summary(savedModel)
}
}
\seealso{
\link{read.ml}

\link{write.ml}
}
