% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/window.R
\docType{methods}
\name{windowOrderBy}
\alias{windowOrderBy}
\alias{windowOrderBy}
\alias{windowOrderBy,character-method}
\alias{windowOrderBy}
\alias{windowOrderBy,Column-method}
\title{windowOrderBy}
\usage{
windowOrderBy(col, ...)

\S4method{windowOrderBy}{character}(col, ...)

\S4method{windowOrderBy}{Column}(col, ...)
}
\arguments{
\item{col}{A column name or Column by which rows are ordered within
windows.}

\item{...}{Optional column names or Columns in addition to col, by
which rows are ordered within windows.}
}
\description{
Creates a WindowSpec with the ordering defined.
}
\note{
windowOrderBy(character) since 2.0.0

windowOrderBy(Column) since 2.0.0
}
\examples{
\dontrun{
  ws <- windowOrderBy("key1", "key2")
  df1 <- select(df, over(lead("value", 1), ws))

  ws <- windowOrderBy(df$key1, df$key2)
  df1 <- select(df, over(lead("value", 1), ws))
}
}
