% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\docType{methods}
\name{dapplyCollect}
\alias{dapplyCollect}
\alias{dapplyCollect,SparkDataFrame,function-method}
\title{dapplyCollect}
\usage{
dapplyCollect(x, func)

\S4method{dapplyCollect}{SparkDataFrame,`function`}(x, func)
}
\arguments{
\item{x}{A SparkDataFrame}

\item{func}{A function to be applied to each partition of the SparkDataFrame.
func should have only one parameter, to which a R data.frame corresponds
to each partition will be passed.
The output of func should be a R data.frame.}
}
\description{
Apply a function to each partition of a SparkDataFrame and collect the result back
to R as a data.frame.
}
\note{
dapplyCollect since 2.0.0
}
\examples{
\dontrun{
  df <- createDataFrame(iris)
  ldf <- dapplyCollect(df, function(x) { x })

  # filter and add a column
  df <- createDataFrame(
          list(list(1L, 1, "1"), list(2L, 2, "2"), list(3L, 3, "3")),
          c("a", "b", "c"))
  ldf <- dapplyCollect(
           df,
           function(x) {
             y <- x[x[1] > 1, ]
             y <- cbind(y, y[1] + 1L)
           })
  # the result
  #       a b c d
  #       2 2 2 3
  #       3 3 3 4
}
}
\seealso{
\link{dapply}

Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{alias}},
  \code{\link{arrange}}, \code{\link{as.data.frame}},
  \code{\link{attach,SparkDataFrame-method}},
  \code{\link{broadcast}}, \code{\link{cache}},
  \code{\link{checkpoint}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{cube}},
  \code{\link{dapply}}, \code{\link{describe}},
  \code{\link{dim}}, \code{\link{distinct}},
  \code{\link{dropDuplicates}}, \code{\link{dropna}},
  \code{\link{drop}}, \code{\link{dtypes}},
  \code{\link{exceptAll}}, \code{\link{except}},
  \code{\link{explain}}, \code{\link{filter}},
  \code{\link{first}}, \code{\link{gapplyCollect}},
  \code{\link{gapply}}, \code{\link{getNumPartitions}},
  \code{\link{group_by}}, \code{\link{head}},
  \code{\link{hint}}, \code{\link{histogram}},
  \code{\link{insertInto}}, \code{\link{intersectAll}},
  \code{\link{intersect}}, \code{\link{isLocal}},
  \code{\link{isStreaming}}, \code{\link{join}},
  \code{\link{limit}}, \code{\link{localCheckpoint}},
  \code{\link{merge}}, \code{\link{mutate}},
  \code{\link{ncol}}, \code{\link{nrow}},
  \code{\link{persist}}, \code{\link{printSchema}},
  \code{\link{randomSplit}}, \code{\link{rbind}},
  \code{\link{rename}}, \code{\link{repartitionByRange}},
  \code{\link{repartition}}, \code{\link{rollup}},
  \code{\link{sample}}, \code{\link{saveAsTable}},
  \code{\link{schema}}, \code{\link{selectExpr}},
  \code{\link{select}}, \code{\link{showDF}},
  \code{\link{show}}, \code{\link{storageLevel}},
  \code{\link{str}}, \code{\link{subset}},
  \code{\link{summary}}, \code{\link{take}},
  \code{\link{toJSON}}, \code{\link{unionByName}},
  \code{\link{union}}, \code{\link{unpersist}},
  \code{\link{withColumn}}, \code{\link{withWatermark}},
  \code{\link{with}}, \code{\link{write.df}},
  \code{\link{write.jdbc}}, \code{\link{write.json}},
  \code{\link{write.orc}}, \code{\link{write.parquet}},
  \code{\link{write.stream}}, \code{\link{write.text}}
}
\concept{SparkDataFrame functions}
