% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RoMLE.error.R
\name{RoMLE.error}
\alias{RoMLE.error}
\title{Robust Maximum Likelihood Estimation for Spatial Error Model}
\usage{
RoMLE.error(
  initial.beta,
  initial.s2,
  initial.lambda,
  W,
  y,
  x,
  phi.function,
  converge.v,
  iter,
  print.values
)
}
\arguments{
\item{initial.beta}{initial value of coefficients}

\item{initial.s2}{initial value of varaince}

\item{initial.lambda}{initial value of autocorrelation parameters}

\item{W}{a symmetric weight matrix}

\item{y}{dependent variable}

\item{x}{independent variables}

\item{phi.function}{a robust m-estimator function, should be set as 1 for Cauchy, 2 for Welsch, 3 for Insha and 4 for Logistic}

\item{converge.v}{converge value for fisher scoring algorithm, can be set as 1e-04}

\item{iter}{iteration number for fisher scoring algorithm, set by users (e.g. 100)}

\item{print.values}{printing estimated values for each step until converge, should be set TRUE or FALSE}
}
\value{
coefficients, lambda, s2, Phi
}
\description{
This package provides robust maximum likelihood estimation for spatial error model.
}
\examples{
#spdep library can be used to create a weight matrix from listw
#require(spdep)
#W <- as(listw, "CsparseMatrix")

#example 1
data(TRQWM)
data(unemployment_data)
data(unemployment_coefs)

y <- unemployment_data$unemployment
x <- unemployment_data$urbanization

#initial values was taken from MLE
initial.beta <- unemployment_coefs[1:2,2]
initial.lambda <- unemployment_coefs[3,2]
initial.s2 <- unemployment_coefs[4,2]

RoMLE.error(initial.beta, initial.s2, initial.lambda, W=TRQWM, y, x,
            phi.function=3, converge.v=0.0001, iter=100, print.values=TRUE)

#example 2
data(TRQWM)
data(IPS_data)
data(IPS_coefs)
y <- IPS_data[,3]
x <- IPS_data[,4:10]

#initial values was taken from MLE
initial.beta <- IPS_coefs[1:8,2]
initial.lambda <- IPS_coefs[9,2]
initial.s2 <- IPS_coefs[10,2]
RoMLE.error(initial.beta, initial.s2, initial.lambda, W=TRQWM, y, x,
            phi.function=3, converge.v=0.0001, iter=100, print.values=TRUE)

}
\references{
Yildirim, V. and Kantar, Y.M. (2020). Robust estimation of spatial error model. in Journal of Statistical Computation and Simulation \url{https://doi.org/10.1080/00949655.2020.1740223}

Yildirim, V., Mert Kantar, Y. (2019). Spatial Statistical Analysis of Participants in The Individual Pension System of Turkey. Eskisehir Teknik Universitesi Bilim Ve Teknoloji Dergisi B - Teorik Bilimler, 7(2), 184-194 \url{https://doi.org/10.20290/estubtdb.518706}
}
