% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Auc.R
\name{Auc}
\alias{Auc}
\title{Calculate area under the ROC curve (AUC) for a forecast and its verifying binary observation, and estimate the variance of the AUC}
\usage{
Auc(fcst, obs, handle.na = c("na.fail", "only.complete.pairs"),
  use_fn = c("C++", "R"))
}
\arguments{
\item{fcst}{vector of forecasts}

\item{obs}{vector of binary observations (0 for non-occurrence, 1 for occurrence of the event)}

\item{handle.na}{how should missing values in forecasts and observations be handled; possible values are 'na.fail' and 'only.complete.pairs'; default: 'na.fail'}

\item{use_fn}{the function used for the calculation: 'C++' (default) for the fast C++ implementation, or 'R' for the slow (but more readable) R implementation}
}
\value{
vector containing AUC and its estimated sampling standard deviation
}
\description{
Calculate area under the ROC curve (AUC) for a forecast and its verifying binary observation, and estimate the variance of the AUC
}
\examples{
data(eurotempforecast)
Auc(rowMeans(ens.bin), obs.bin)
}
\references{
DeLong et al (1988): Comparing the Areas under Two or More Correlated Receiver Operating Characteristic Curves: A Nonparametric Approach. Biometrics. http://dx.doi.org/10.2307/2531595
Sun and Xu (2014): Fast Implementation of DeLong's Algorithm for Comparing the Areas Under Correlated Receiver Operating Characteristic Curves. IEEE Sign Proc Let 21(11). http://dx.doi.org/10.1109/LSP.2014.2337313
}
\seealso{
AucDiff
}
