% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsBrier.R
\name{EnsBrier}
\alias{EnsBrier}
\alias{FairBrier}
\title{Calculate the ensemble-adjusted Brier Score}
\usage{
EnsBrier(ens, obs, R.new = NA)

FairBrier(ens, obs)
}
\arguments{
\item{ens}{a N*R matrix representing N time instances of R-member ensemble forecasts of binary events; ens[t,r]=1 if the r-th ensemble member at time t predicted the event, otherwise ens[t,r]=0}

\item{obs}{a numeric vector of length N with binary observations; obs[t]=1 if the event happens at time t, otherwise obs[t]=0}

\item{R.new}{ensemble size for which the scores should be adjusted}
}
\value{
numeric vector of length N with the ensemble-adjusted Brier scores
}
\description{
Calculate the ensemble-adjusted Brier Score
}
\details{
`FairBrier(ens, obs)` returns `EnsBrier(ens, obs, R.new=Inf)`
}
\examples{
data(eurotempforecast)
mean(EnsBrier(ens.bin, obs.bin, R.new=Inf))
}
\references{
Ferro CAT, Richardson SR, Weigel AP (2008) On the effect of ensemble size on the discrete and continuous ranked probability scores. Meteorological Applications. doi: 10.1002/met.45
}
\seealso{
EnsRps, EnsCrps, ScoreDiff, SkillScore
}
