% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_refine.R
\name{refine}
\alias{refine}
\title{Refining splines through adding knots}
\usage{
refine(object, mult = 2, newknots = NULL)
}
\arguments{
\item{object}{\code{Splinets}-object, the object to be represented as a \code{Splinets}-object over a refined set of knots;}

\item{mult}{positive integer, refining rate; The number of the knots to be put equally spaced between the existing knots.}

\item{newknots}{\code{m} vector, new knots; 
The knots do not need to be ordered and knots from the input \code{Splinets}-object knots are allowed since any ties are resolved.}
}
\value{
A \code{Splinet} object with the new refined knots and the new matrix of derivatives is evaluated at the new knots combined with the original ones.
}
\description{
Any spline of a given order remains a spline of the same order if one considers it on a bigger set of knots than the original one.
             However, this embedding changes the \code{Splinets} representation of the so-refined spline. 
             The function evaluates the corresponding \code{Splinets}-object.
}
\details{
The function merges new knots with the ones from the input \code{object}. It utilizes \code{deriva()}-function to evaluate the derivative at the refined knots. 
It removes duplications of the refined knots, and account also for the not-fully supported case.
In the case when the range of the additional knots extends beyond the knots of the input \code{Splinets}-object,
the support sets of the output \code{Splinets}-object account for the smaller than the full support.
}
\section{References}{

Liu, X., Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. (2019) "Splinets -- efficient orthonormalization of the B-splines."  <arXiv:1910.07341>.

Podg\eqn{\mbox{\'o}}{o}rski, K. (2021) 
"\code{Splinets} -- splines through the Taylor expansion, their support sets and orthogonal bases." <arXiv:2102.00733>.
}

\examples{
#-------------------------------------------------#
#----Refining splines - the full support case-----#
#-------------------------------------------------#
k=3 # order
n = 16 # number of the internal knots (excluding the endpoints)
xi = seq(0, 1, length.out = n+2)
set.seed(5)
S=matrix(rnorm((n+2)*(k+1)),ncol=(k+1))

spl=construct(xi,k,S) 

plot(spl) # plotting a spline


rspl=refine(spl) # refining the equidistant by doubling its knots
plot(rspl)
rspl@equid  # the outcome is equidistant

#a non-equidistant case
n=17; k=4
xi=sort(runif(n+2)); xi[1]=0; xi[n+2]=1 
S=matrix(rnorm((n+2)*(k+1)),ncol=(k+1))
spl=construct(xi,k,S) 
plot(spl)
mult=3 #adding two knots between each subsequent pair of the original knots
rspl=refine(spl,mult) 
is.splinets(rspl)
plot(rspl)

#adding specific knots
rspl=refine(spl,newknots=c(0.5,0.75))
rspl@knots
is.splinets(rspl)
plot(rspl)

#----------------------------------------------------#
#----Refining splines - the partial support case-----#
#----------------------------------------------------#

Bases=splinet(xi,k)
plot(Bases$bs)
Base=Bases$bs

BS_Two=subsample(Bases$bs,c(1,length(Base@der)))
plot(BS_Two)
A=matrix(c(1,-1),ncol=2)
spl=lincomb(BS_Two,A)

rspl=refine(spl) #doubling the number of knots
plot(rspl)
is.splinets(rspl)
rspl@supp #the support is evaluated 
spl@supp

#The case of adding knots explicitely
BS_Middle=subsample(Bases$bs,c(floor(length(Base@der)/2)))
spls=gather(spl,BS_Middle)
plot(spls)

rspls=refine(spls, newknots=c(0.2,0.5,0.85)) #two splines with partial support sets 
                                             #by adding three knots to B-splines
plot(rspls)

#----------------------------------------------------#
#------Refining splines over the larger range--------#
#----------------------------------------------------#

k=4 # order
n = 25 # number of the internal knots (excluding the endpoints)
xi = seq(0, 1, length.out = n+2)
S=matrix(rnorm((n+2)*(k+1)),ncol=(k+1))

spl=construct(xi,k,S) 

plot(spl) # plotting a spline
newknots=c(-0.1,0.4,0.6,1.2)  #the added knots create larger range 
rspl=refine(spl,newknots=newknots)
spl@supp #the original spline has the full support
rspl@supp #the embedded spline has partial support
spl@equid
rspl@equid
plot(rspl)
}
\seealso{
\code{\link{deriva}} for computing derivatives at selected points; 
\code{\link{project}} for an orthogonal projection into a space of splines;
}
