% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{soften}
\alias{soften}
\title{Create a `soft tree' structure with softening parameters set
using one of the named method.}
\usage{
soften(fit, ds, method)
}
\arguments{
\item{fit}{A classification tree - either an object \code{tree} which represents a classification tree,
or already a `soft tree' like created by the \code{\link{softsplits}} function.}

\item{ds}{A data frame used as training data for softening}

\item{method}{A name of softening method.
 One of: "DR0", "DR1", "DR2", ..., "ESD", "C4.5", "optim_d", "optim_d^2", "optim_d^4", "optim_auc"

 The 'method = "DR\emph{x}"' for some number \emph{x}: The softening parameters are set
 according to `data ranges' appropriate to tree nodes.
 The parameters are configured such that in each node the distance of the boundary of the softened area from split value is
 \eqn{2^{-x}r}, where \eqn{r} is the distance from the split value to the furthest data point in the tree node
 projected to the direction from the split value to the boundary.

 The 'method = "ESD"' sets boundaries of the softening using error standard deviation.
 This is how C4.5 method sets "probabilistic splits"; for that reason value \code{"C4.5"} is an alias for \code{"ESD"}.

 The 'method = "optim_d^\emph{q}"' for some number \emph{q}: The softening parameters are set
 by optimization process which minimizes \eqn{\code{mean}((1.0-p)^q)} where \eqn{p} is for each data point in 
 \code{ds} the predicted probability of the correct label.

 If 'method = "optim_auc"': The classification tree \code{fit} must perform prediction to two classes.
 The value of the `area under ROC curve' computed on the data set \code{ds} is maximized by optimization.}
}
\value{
The `soft tree' structure representing the same tree structure
 as given in the parameter \code{fit},
 but with softening parameters set using the given method.
}
\description{
This is a convenience method implemented over \code{\link{softsplits}}
and the softening functions from this package.
}
\seealso{
\code{\link{predictSoftsplits}}.
}
