% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/standardModels.R
\name{m7}
\alias{m7}
\title{Create an M7 type extension of the Cairns-Blake-Dowd mortality model}
\usage{
m7(link = c("logit", "log"))
}
\arguments{
\item{link}{defines the link function and random component associated with
the mortality model. \code{"log"} would assume that deaths follow a Poisson
distribution and use a log link while \code{"logit"} would assume that
deaths follow a Binomial distribution and a logit link. Note that the default
is the logit link.}
}
\value{
An object of class \code{"StMoMo"}.
}
\description{
Utility function to initialise a \code{StMoMo} object representing the
M7 extension of the Cairns-Blake-Dowd mortality model introduced
in Cairns et al (2009).
}
\details{
The created model is either a logit-Binomial or a log-Poisson version of the
M7 model which has predictor structure
\deqn{\eta_{xt} = \kappa_t^{(1)} + (x-\bar{x})\kappa_t^{(2)} +
                           ((x-\bar{x})^2 - \hat{\sigma}^2_x)\kappa_t^{(2)} +  \gamma_{t-x},}
where \eqn{\bar{x}} is the average age in the data and \eqn{\hat{\sigma}^2_x}
is the average value of \eqn{(x-\bar{x})^2}.

Identifiability of the model is accomplished by applying parameters constraints
\deqn{\sum_c\gamma_c = 0, \sum_c c\gamma_c = 0, \sum_c c^2\gamma_c = 0}
which ensure that the cohort effect fluctuates around zero and has no linear
or quadratic trend. These constraints are applied using the strategy discussed
in Appendix A of Haberman and Renshaw (2011).
}
\examples{
M7 <- m7()
Dxt <- EWMaleData$Dxt
Ext <- EWMaleData$Ext + 0.5 * EWMaleData$Dxt
wxt <- genWeightMat(55:89,  EWMaleData$years, clip = 3)
M7fit <- fit(M7, Dxt = Dxt, Ext = Ext, ages = EWMaleData$ages,
             years = EWMaleData$years, ages.fit = 55:89)
plot(M7fit, parametricbx = FALSE)
}
\references{
Cairns, A. J. G., Blake, D., Dowd, K., Coughlan, G. D., Epstein, D., Ong, A.,
& Balevich, I. (2009). A quantitative comparison of stochastic mortality models using
data from England and Wales and the United States.
North American Actuarial Journal, 13(1), 1-35.

Haberman, S., & Renshaw, A. (2011). A comparative study of parametric mortality projection
models. Insurance: Mathematics and Economics, 48(1), 35-55.
}
\seealso{
\code{\link{StMoMo}}, \code{\link{cbd}}, \code{\link{m6}},
\code{\link{m8}}
}

