# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'@title C++ Interface to Gillespie Stochastic Simulation Algorithm single trajectory
#'
#'@description
#'\code{ssa} Called by StochKit2R ssaSingle function, do not call this C++ interface directly
#'
#'@param StochKit2Rmodel R list (Rcpp List built from buildStochKit2Rmodel output)
#'@param outputFileNameString Character string with path to output file.
#'@param startTime Simulation start time
#'@param endTime Simulation end time
#'@param seed Seed for random number generator
#'@return NULL
#'@keywords internal
ssaSingleStochKit2RInterface <- function(StochKit2Rmodel, outputFileNameString, startTime, endTime, seed) {
    invisible(.Call('StochKit2R_ssaSingleStochKit2RInterface', PACKAGE = 'StochKit2R', StochKit2Rmodel, outputFileNameString, startTime, endTime, seed))
}

#'@title C++ Interface to Gillespie Stochastic Simulation Algorithm
#'
#'@description
#'\code{ssa} Called by StochKit2R ssa function, do not call this C++ interface directly
#'
#'@param StochKit2Rmodel R list (Rcpp List built from buildStochKit2Rmodel output)
#'@param outputDirNameString Character string with path to output directory. Should end in path separator.
#'@param time Simulation time of each realization
#'@param realizations Number of realizations
#'@param intervals Number of output intervals. Default 0 outputs at end time only. 1=keep data at start and end time, 2=keep data at start, middle, and end times, etc. Note data is stored at (intervals+1) equally spaced time points.
#'@param keepStats Keep means and variances data
#'@param keepTrajectories Keep trajectory data
#'@param keepHistograms Keep histogram data
#'@param bins Number of histogram bins
#'@param seed Seed for random number generator
#'@param p  Override default and specify the number of processes (threads) to use. By default (=0), the number of processes will be determined automatically
#'@return NULL
#'@keywords internal
ssaStochKit2RInterface <- function(StochKit2Rmodel, outputDirNameString, time, realizations, intervals, keepStats, keepTrajectories, keepHistograms, bins, seed, p) {
    invisible(.Call('StochKit2R_ssaStochKit2RInterface', PACKAGE = 'StochKit2R', StochKit2Rmodel, outputDirNameString, time, realizations, intervals, keepStats, keepTrajectories, keepHistograms, bins, seed, p))
}

#'@title C++ Interface to Explicit Adaptive Tau-Leaping simulation
#'
#'@description
#'\code{ssa} Called by StochKit2R tauLeaping function, do not call this C++ interface directly
#'
#'@param StochKit2Rmodel R list (Rcpp List built from buildStochKit2Rmodel output)
#'@param outputDirNameString Character string with path to output directory. Should end in path separator.
#'@param time Simulation time of each realization
#'@param realizations Number of realizations
#'@param intervals Number of output intervals. Default 0 outputs at end time only. 1=keep data at start and end time, 2=keep data at start, middle, and end times, etc. Note data is stored at (intervals+1) equally spaced time points.
#'@param keepStats Keep means and variances data
#'@param keepTrajectories Keep trajectory data
#'@param keepHistograms Keep histogram data
#'@param bins Number of histogram bins
#'@param seed Seed for random number generator
#'@param p Override default and specify the number of processes (threads) to use. By default (=0), the number of processes will be determined automatically
#'@param epsilon Set the tolerance (applicable to tauLeaping only), default is 0.03. Valid values: must be greater than 0.0 and less than 1.0
#'@param threshold Set the threshold (minimum number of reactions per leap before switching to ssa) for tauLeaping
#'@return NULL
#'@keywords internal
tauLeapingStochKit2RInterface <- function(StochKit2Rmodel, outputDirNameString, time, realizations, intervals, keepStats, keepTrajectories, keepHistograms, bins, seed, p, epsilon, threshold) {
    invisible(.Call('StochKit2R_tauLeapingStochKit2RInterface', PACKAGE = 'StochKit2R', StochKit2Rmodel, outputDirNameString, time, realizations, intervals, keepStats, keepTrajectories, keepHistograms, bins, seed, p, epsilon, threshold))
}

