% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_bart.R
\name{ple_bart}
\alias{ple_bart}
\title{Patient-level Estimates: BART}
\usage{
ple_bart(Y, A, X, Xtest, family = "gaussian", ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate matrix. Must be numeric.}

\item{Xtest}{Test set}

\item{family}{Outcome type ("gaussian", "binomial"), default is "gaussian"}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Patient-level estimates (E(Y|X,1), E(Y|X,0), E(Y|X,1)-E(Y|X,0)) for train/test sets.
 \itemize{
  \item mods - trained model(s)
  \item mu_train - Patient-level estimates (training set)
  \item mu_test - Patient-level estimates (test set)
}
}
\description{
Uses the BART algorithm (from BART R package) to obtain patient-level estimates.
Used for continuous or binary outcomes, with output estimates of
E(Y|X,A=a) and E(Y|X,A=1)-E(Y|X,A=0) (PLE). In progress.
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A
train = data.frame(Y, A, X)

# BART #
\donttest{
mod1 = ple_bart(train=train, Xtest=X)

summary(mod1$mu_train$PLE)
}

}
\seealso{
\code{\link{PRISM}}, \code{\link{BART}}
}
