% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_ctree.R
\name{submod_ctree}
\alias{submod_ctree}
\title{Subgroup Identification: Conditional Inference Trees (CTREE)}
\usage{
submod_ctree(Y, A, X, Xtest, mu_train, minbucket = floor(dim(X)[1] *
  0.05), maxdepth = 4, outcome_PLE = FALSE, family = "gaussian", ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate matrix. Must be numeric.}

\item{Xtest}{Test set}

\item{mu_train}{Patient-level estimates (See PLE_models)}

\item{minbucket}{Minimum number of observations in a tree node.
Default = floor( dim(train)[1]*0.05  )}

\item{maxdepth}{Maximum depth of any node in the tree (default=4)}

\item{outcome_PLE}{If TRUE, use PLE as outcome (mu_train must contain PLEs).}

\item{family}{Outcome type ("gaussian", "binomial", "survival), default is "gaussian"}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
CTREE model, predictions, and identified subgroups.
 \itemize{
  \item mod - CTREE model object
  \item Subgrps.train - Identified subgroups (training set)
  \item Subgrps.test - Identified subgroups (test set)
  \item pred.train - Predictions (training set)
  \item pred.test - Predictions (test set)
}
}
\description{
Uses the CTREE (conditional inference trees) algorithm to identify subgroups.
Usable for continuous and binary outcomes.
Option to use the observed outcome or PLEs for subgroup identification.
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

res_ctree1 = submod_ctree(Y, A, X, Xtest=X, family="gaussian")
res_ctree2 = submod_ctree(Y, A, X, Xtest=X, family="gaussian", maxdepth=2, minsize=100)
plot(res_ctree1$mod)
plot(res_ctree2$mod)

# Survival #
dat_surv = generate_subgrp_data(family="survival")
Y = dat_surv$Y
X = dat_surv$X
A = dat_surv$A
res_ctree3 = submod_ctree(Y, A, X, Xtest=X, family="survival")
plot(res_ctree3$mod)

}
\seealso{
\code{\link{PRISM}}, \code{\link{ctree}}
}
