% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_causal_forest.R
\name{ple_causal_forest}
\alias{ple_causal_forest}
\title{Patient-level Estimates: Causal Forest}
\usage{
ple_causal_forest(Y, A, X, Xtest, tune = FALSE, num.trees = 500,
  family = "gaussian", mod.A = "mean", ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{tune}{If TRUE, use grf automatic hyper-parameter tuning. If FALSE (default), no tuning.}

\item{num.trees}{Number of trees (default=500)}

\item{family}{Outcome type ("gaussian", "binomial"), default is "gaussian"}

\item{mod.A}{Model for estimating P(A|X). Default is "mean" calculates the sample mean.
If mod.A="RF", estimate P(A|X) using regression_forest (applicable for non-RCTs).}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained causal_forest and regression_forest models.
 \itemize{
  \item mod - trained model(s)
  \item pred.fun - Prediction function for trained model(s)
}
}
\description{
Uses the causal forest algorithm (grf R package) to obtain patient-level estimates, 
E(Y|A=1), E(Y|A=0), and E(Y|A=1)-E(Y|A=0). Usable for continuous or binary outcomes.
}
\references{
Athey S, Tibshirani J, Wagner S. Generalized Random Forests. 
\url{https://arxiv.org/abs/1610.01271}
}
