% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transphere.R
\name{transphere}
\alias{transphere}
\title{Convertion between declinaison/inclination/intensity and cartesian
coordinates}
\usage{
transphere(dec = NA, inc = NA, int = 1, x = NA, y = NA, z = NA,
  into = "other")
}
\arguments{
\item{dec}{declination of the data; it is the angle from the north
taken on an horizontal plane. It is measured clockwise from North and ranges
from 0 to 360° (Tauxe 2010). Values outside this range are corrected by
incfix().}

\item{inc}{inclination of the data; it is the angle from the
horizontal, is positive downward, and ranges from +90° for straight down to
-90° for straight up (Tauxe, 2010). Values outside this range are corrected
by incfix().}

\item{int}{intensity of the data. Defaults to one (unit sphere).}

\item{x, y, z}{cartesian coordinates. x is the North, y the East, and z
straight down. If dec and inc are not provided they are used to be converted
back in dec, inc and int data. Output is corrected by incfix().}

\item{into}{overriding parameter for generalisation: if "dii" dec, inc and
int will remain as they are, and if "xyz" cartesian coordinates will remain
as they are}
}
\value{
a list of coordinates, in cartesian form or dec, inc, int form
following the input
}
\description{
Convertion between declinaison/inclination/intensity and cartesian
coordinates (modified from RFOC package)
}
\examples{
transphere(dec = c(65,135), inc = c(32,74))

l <- transphere(dec = c(65,135), inc = c(32,74))
transphere(x = l$x, y = l$y, z = l$z)

}
\seealso{
\code{\link{fmod}}, \code{\link{dipfix}} and \code{\link{incfix}}
}
