% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpk-read_data.R
\name{filter_df_raw}
\alias{filter_df_raw}
\title{Perform Temperature Filters on Raw Data}
\usage{
filter_df_raw(
  df_raw,
  low_irrad_thresh = 950,
  high_irrad_thresh = 1050,
  temp_range = 3
)
}
\arguments{
\item{df_raw}{A dataframe containing IV curve data.}

\item{low_irrad_thresh}{A lower bound for irradiance. Default = 995}

\item{high_irrad_thresh}{An upper bound for irradiance. Default = 1005}

\item{temp_range}{An acceptable range of temperature from the mean. The
filter will allow this value above and below the mean temperature, in Celcius.}
}
\value{
df_reduced, a necessary dataframe for IV Curve Translation (see \code{\link{IVcorr_full}}) This
dataframe has been filtered as described above.
}
\description{
Filters a raw dataframe of IV curve data according to specified
irradiance levels and temperature range. The function removes data below
the low irradiance and above the high irradiance thresholds, calculates
mean temperature of the remaining data, and then removes data outside of the
temp range around mean temperature (Celsius).
}
\examples{
df_reduced <- filter_df_raw(df_wbw)

}
