% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpk-piv_iv_week.R
\name{p_iv.week}
\alias{p_iv.week}
\title{Obtain Psuedo IV Curve for given week}
\usage{
p_iv.week(df, temp, alpha = 0.5, N_c, isc_1sun = NULL)
}
\arguments{
\item{df}{A dataframe containing IV curve data.}

\item{temp}{The temperature at which the data was obtained}

\item{alpha}{Parameter for "emp" and "val" methods.}

\item{N_c}{Number of cells in series. Equal to the total number of cells in the system.}

\item{isc_1sun}{(optional) Input a Isc 1-Sun value manually. Leave NULL to have one generated
from the dataframe.}
}
\value{
Psuedo-IV Curve data (dataframe) for a single, given week.
}
\description{
Obtain Psuedo IV Curve for given week
}
\examples{
df_slice <- dplyr::filter(df_wbw, df_wbw$n_period == 1)

# Check that this has enough data! needs more than 10 rows to be meaningful
nrow(df_slice)

# needs median temperature
temp <- median_temp(df_wbw)

res <- p_iv.week(df_slice, temp = temp, N_c = 4)


}
