% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supercell_assign.R
\name{supercell_assign}
\alias{supercell_assign}
\title{Assign super-cells to the most aboundant cluster}
\usage{
supercell_assign(
  clusters,
  supercell_membership,
  method = c("jaccard", "relative", "absolute")
)
}
\arguments{
\item{clusters}{a vector of clustering assignment}

\item{supercell_membership}{a vector of assignment of single-cell data to super-cells (membership field of \link{SCimplify} function output)}

\item{method}{method to define the most abuldant cell cluster within super-cells. Available: "jaccard" (default), "relative", "absolute".
\itemize{
  \item jaccard - assignes super-cell to cluster with the maximum jaccard coefficient (recommended)
  \item relative - assignes super-cell to cluster with the maximum relative abundance (normalized by cluster size), may result in assignment of super-cells to poorly represented (small) cluser due to normalizetaion
  \item absolute - assignes super-cell to cluster with the maximum absolute abundance within super-cell, may result in disappearence of poorly represented (small) clusters
}}
}
\value{
a vector of super-cell assignment to clusters
}
\description{
Assign super-cells to the most aboundant cluster
}
