% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit_SurvSurv.R
\name{marginal_gof_scr_S_plot}
\alias{marginal_gof_scr_S_plot}
\alias{marginal_gof_scr_T_plot}
\title{Goodness-of-fit plot for the marginal survival functions}
\usage{
marginal_gof_scr_S_plot(fitted_model, grid, treated, ...)

marginal_gof_scr_T_plot(fitted_model, grid, treated, ...)
}
\arguments{
\item{fitted_model}{Returned value from \code{\link[=fit_model_SurvSurv]{fit_model_SurvSurv()}}. This object
essentially contains the estimated identifiable part of the joint
distribution for the potential outcomes.}

\item{grid}{Grid of time-points at which the model-based estimated regression
functions, survival functions, or probabilities are evaluated.}

\item{treated}{(numeric) Treatment group. Should be \code{0} or \code{1}.}

\item{...}{Additional arguments to pass to \code{\link[=plot]{plot()}}.}
}
\value{
\code{NULL}
}
\description{
The \code{\link[=marginal_gof_scr_S_plot]{marginal_gof_scr_S_plot()}} and \code{\link[=marginal_gof_scr_T_plot]{marginal_gof_scr_T_plot()}} functions
plot the estimated marginal survival functions for the surrogate and true
endpoints. In these plots, it is assumed that the copula model has been
fitted for \eqn{(T_0, \tilde{S}_0, \tilde{S}_1, T_1)'} where \deqn{S_k =
\min(\tilde{S_k}, T_k)} is the (composite) surrogate of interest. In these
plots, the model-based survival functions for \eqn{(T_0, S_0, S_1, T_1)'} are
plotted together with the corresponding Kaplan-Meier etimates.
}
\section{True Endpoint}{
The marginal goodness-of-fit plots for the true endpoint, build by
\code{\link[=marginal_gof_scr_T_plot]{marginal_gof_scr_T_plot()}}, is simply a comparison of the model-based
estimate of \eqn{P(T_k > t)} with the Kaplan-Meier (KM) estimate obtained
with \code{\link[survival:survfit]{survival::survfit()}}. A pointwise 95\% confidence interval for the KM
estimate is also plotted.
}

\section{Surrogate Endpoint}{
The model-based estimate of \eqn{P(S_k > s)} follows indirectly from the
fitted copula model because the copula model has been fitted for
\eqn{\tilde{S}_k} instead of \eqn{S_k}. However, the model-based estimate
still follows easily from the copula model as follows,
\deqn{P(S_k > s) = P(\min(\tilde{S}_k, T_k)) = P(\tilde{S}_k > s, T_k > s).}

The \code{\link[=marginal_gof_scr_T_plot]{marginal_gof_scr_T_plot()}} function plots the model-based estimate for
\eqn{P(\tilde{S}_k > s, T_k > s)} together with the KM estimate (see above).
}

\examples{
# Load Ovarian data
data("Ovarian")
# Recode the Ovarian data in the semi-competing risks format.
data_scr = data.frame(
  ttp = Ovarian$Pfs,
  os = Ovarian$Surv,
  treat = Ovarian$Treat,
  ttp_ind = ifelse(
    Ovarian$Pfs == Ovarian$Surv &
      Ovarian$SurvInd == 1,
    0,
    Ovarian$PfsInd
  ),
  os_ind = Ovarian$SurvInd
)
# Fit copula model.
fitted_model = fit_model_SurvSurv(data = data_scr,
                                  copula_family = "clayton",
                                  n_knots = 1)
# Define grid for GoF plots.
grid = seq(from = 1e-3,
           to = 2.5,
           length.out = 30)
# Assess marginal goodness-of-fit in the control group.
marginal_gof_scr_S_plot(fitted_model, grid = grid, treated = 0)
marginal_gof_scr_T_plot(fitted_model, grid = grid, treated = 0)
# Assess goodness-of-fit of the association structure, i.e., the copula.
prob_dying_without_progression_plot(fitted_model, grid = grid, treated = 0)
mean_S_before_T_plot_scr(fitted_model, grid = grid, treated = 0)
}
