% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_BinCont_copula.R
\name{fit_copula_model_BinCont}
\alias{fit_copula_model_BinCont}
\title{Fit copula model for binary true endpoint and continuous surrogate endpoint}
\usage{
fit_copula_model_BinCont(
  data,
  copula_family,
  marginal_surrogate,
  marginal_surrogate_estimator = NULL,
  twostep = FALSE,
  fitted_model = NULL,
  maxit = 500,
  method = "BFGS"
)
}
\arguments{
\item{data}{A data frame in the correct format (See details).}

\item{copula_family}{One of the following parametric copula families:
\code{"clayton"}, \code{"frank"}, \code{"gaussian"}, or \code{"gumbel"}. The first element in
\code{copula_family} corresponds to the control group, the second to the
experimental group.}

\item{marginal_surrogate}{Marginal distribution for the surrogate. For all
available options, see \code{?Surrogate::cdf_fun}.}

\item{marginal_surrogate_estimator}{Not yet implemented}

\item{twostep}{(boolean) if \code{TRUE}, the two step estimator implemented in
\code{\link[=twostep_BinCont]{twostep_BinCont()}} is used for estimation.}

\item{fitted_model}{Fitted model from which initial values are extracted. If
\code{NULL} (default), standard initial values are used. This option intended
for when a model is repeatedly fitted, e.g., in a bootstrap.}

\item{maxit}{Maximum number of iterations for the numeric optimization,
defaults to 500.}

\item{method}{Optimization algorithm for maximizing the objective function.
For all options, see \code{?maxLik::maxLik}. Defaults to \code{"BFGRS"}.}
}
\value{
WIP
}
\description{
The function \code{\link[=fit_copula_model_BinCont]{fit_copula_model_BinCont()}} fits the copula model for a
continuous surrogate endpoint and binary true endpoint. Because the bivariate
distributions of the surrogate-true endpoint pairs are functionally
independent across treatment groups, a bivariate distribution is fitted in
each treatment group separately.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Load Schizophrenia data set.
data("Schizo_BinCont")
# Perform listwise deletion.
na = is.na(Schizo_BinCont$CGI_Bin) | is.na(Schizo_BinCont$PANSS)
X = Schizo_BinCont$PANSS[!na]
Y = Schizo_BinCont$CGI_Bin[!na]
Treat = Schizo_BinCont$Treat[!na]
# Ensure that the treatment variable is binary.
Treat = ifelse(Treat == 1, 1, 0)
data = data.frame(X,
                  Y,
                  Treat)
# Fit copula model.
fitted_model = fit_copula_model_BinCont(data, "clayton", "normal", twostep = FALSE)
# Perform sensitivity analysis with a very low number of replications.
sens_results = sensitivity_analysis_BinCont_copula(
  fitted_model,
  10,
  lower = c(-1,-1,-1,-1),
  upper = c(1, 1, 1, 1),
  n_prec = 1e3
)
\dontshow{\}) # examplesIf}
}
