#' @docType package
#'
#' @name TAF-package
#'
#' @aliases TAF
#'
#' @title Functions to Support the ICES Transparent Assessment Framework
#'
#' @description
#' Functions to support the ICES Transparent Assessment Framework, to organize
#' data, methods, and results used in ICES assessments.
#'
#' @details
#' \emph{Initial TAF steps:}
#' \tabular{ll}{
#'   \code{\link{draft.data}}     \tab draft DATA.bib file\cr
#'   \code{\link{draft.software}} \tab draft SOFTWARE.bib file\cr
#'   \code{\link{period}}         \tab paste period string for DATA.bib\cr
#'   \code{\link{taf.bootstrap}}  \tab set up data files and software\cr
#'   \code{\link{taf.skeleton}}   \tab create empty TAF template
#' }
#' \emph{Running scripts:}
#' \tabular{ll}{
#'   \code{\link{clean}}     \tab clean TAF directories\cr
#'   \code{\link{make}}      \tab run R script if needed\cr
#'   \code{\link{makeAll}}   \tab run all TAF scripts as needed\cr
#'   \code{\link{makeTAF}}   \tab run TAF script if needed\cr
#'   \code{\link{msg}}       \tab show message\cr
#'   \code{\link{sourceAll}} \tab run all TAF scripts\cr
#'   \code{\link{sourceTAF}} \tab run TAF script
#' }
#' \emph{File management:}
#' \tabular{ll}{
#'   \code{\link{convert.spaces}} \tab convert spaces\cr
#'   \code{\link{cp}}             \tab copy files\cr
#'   \code{\link{mkdir}}          \tab create directory\cr
#'   \code{\link{os.linux}}       \tab operating system\cr
#'   \code{\link{os.macos}}       \tab operating system\cr
#'   \code{\link{os.windows}}     \tab operating system\cr
#'   \code{\link{read.taf}}       \tab read TAF table from file\cr
#'   \code{\link{sourceDir}}      \tab read all \code{*.R} files\cr
#'   \code{\link{taf.library}}    \tab load package from TAF library\cr
#'   \code{\link{taf.unzip}}      \tab unzip file\cr
#'   \code{\link{write.taf}}      \tab write TAF table to file
#' }
#' \emph{Tables:}
#' \tabular{ll}{
#'   \code{\link{div}}       \tab divide column values\cr
#'   \code{\link{flr2taf}}   \tab convert FLR to TAF\cr
#'   \code{\link{long2taf}}  \tab convert long format to TAF\cr
#'   \code{\link{long2xtab}} \tab convert long format to crosstab\cr
#'   \code{\link{plus}}      \tab rename plus group column\cr
#'   \code{\link{rnd}}       \tab round column values\cr
#'   \code{\link{sam2taf}}   \tab convert SAM to TAF\cr
#'   \code{\link{taf2long}}  \tab convert TAF to long format\cr
#'   \code{\link{taf2xtab}}  \tab convert TAF to crosstab\cr
#'   \code{\link{tt}}        \tab transpose TAF table\cr
#'   \code{\link{xtab2long}} \tab convert crosstab to long format\cr
#'   \code{\link{xtab2taf}}  \tab convert crosstab to TAF
#' }
#' \emph{Plots:}
#' \tabular{ll}{
#'   \code{\link{lim}}        \tab compute axis limits\cr
#'   \code{\link{taf.colors}} \tab predefined colors\cr
#'   \code{\link{taf.png}}    \tab open PNG graphics device\cr
#'   \code{\link{zoom}}       \tab change lattice text size
#' }
#' \emph{Example tables:}
#' \tabular{ll}{
#'   \code{\link{catage.long}} \tab long format\cr
#'   \code{\link{catage.taf}}  \tab TAF format\cr
#'   \code{\link{catage.xtab}} \tab crosstab format\cr
#'   \code{\link{summary.taf}} \tab summary results
#' }
#' \emph{Administrative tools, rarely used in scripts:}
#' \tabular{ll}{
#'   \code{\link{clean.data}}      \tab clean bootstrap data\cr
#'   \code{\link{clean.library}}   \tab clean TAF library\cr
#'   \code{\link{clean.software}}  \tab clean TAF software\cr
#'   \code{\link{deps}}            \tab list dependencies\cr
#'   \code{\link{detach.packages}} \tab detach all packages\cr
#'   \code{\link{dos2unix}}        \tab convert line endings\cr
#'   \code{\link{download}}        \tab download file\cr
#'   \code{\link{download.github}} \tab download repository\cr
#'   \code{\link{file.encoding}}   \tab examine file encoding\cr
#'   \code{\link{get.remote.sha}}  \tab look up SHA code\cr
#'   \code{\link{is.r.package}}    \tab check if file is an R package\cr
#'   \code{\link{latin1.to.utf8}}  \tab convert file encoding\cr
#'   \code{\link{line.endings}}    \tab examine line endings\cr
#'   \code{\link{rmdir}}           \tab remove empty directory\cr
#'   \code{\link{taf.install}}     \tab install package in TAF library\cr
#'   \code{\link{taf.libPaths}}    \tab add TAF library to search path\cr
#'   \code{\link{taf.session}}     \tab show session information\cr
#'   \code{\link{unix2dos}}        \tab convert line endings\cr
#'   \code{\link{utf8.to.latin1}}  \tab convert file encoding
#' }
#'
#' @author Arni Magnusson and Colin Millar.
#'
#' @references
#' ICES Transparent Assessment Framework: \url{https://taf.ices.dk}.
#'
#' To explore example TAF stock assessments, see the introductory
#' \href{https://www.youtube.com/watch?v=FweJbr9hfdY}{video} and
#' \href{https://github.com/ices-taf/doc/blob/master/tutorial-1/README.md}{tutorial}.
#'
#' The \href{https://github.com/ices-taf/doc/wiki}{TAF Wiki} provides additional
#' help resources.

NA
