# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title TC Track Distance and Direction From Output Grid Point
#' @description Grid point time series of TC distance and direction.
#' @param Gridlon single Grid point longitude
#' @param Gridlat single Grid point latitude
#' @param TClon vector of TC longitudes
#' @param TClat vector of TC latitudes
#' @keywords internal
#' @NoRd 
#' @return two columns for distance in km and cartesian direction in degrees, counterclockwise from the x axis.
#' //@example RdistPi(142,-14,c(144,145),c(-11,-12))
RdistPi <- function(Gridlon, Gridlat, TClon, TClat) {
    .Call(`_TCHazaRds_RdistPi`, Gridlon, Gridlat, TClon, TClat)
}

#' @title Jelesnianski Wind Profile Time Series
#' @description wind profile time series at a grid point
#' @param f single coriolis parameter at the centre of TC in hz
#' @param vMax maximum wind velocity calculation in m/s
#' @param rMax radius of maximum winds in km
#' @param R vector of distances from grid points to TC centre in km
#' @keywords internal
#' @NoRd 
#' @return array with two columns for velocity and then vorticity.
#' //@example JelesnianskiWindProfilePi(-1e-4,20,20,50)
JelesnianskiWindProfilePi <- function(f, vMax, rMax, R) {
    .Call(`_TCHazaRds_JelesnianskiWindProfilePi`, f, vMax, rMax, R)
}

#' @title Rankine Wind Profile Time Series
#' @description wind profile time series at a grid point
#' @param f single coriolis parameter at the centre of TC in hz
#' @param vMax maximum wind velocity calculation in m/s
#' @param rMax radius of maximum winds in km
#' @param R vector of distances from grid points to TC centre in km
#' @keywords internal
#' @NoRd 
#' @return array with two columns for velocity and then vorticity.
#' //@example RankineWindProfilePi(-1e-4,20,20,50)
RankineWindProfilePi <- function(f, vMax, rMax, R) {
    .Call(`_TCHazaRds_RankineWindProfilePi`, f, vMax, rMax, R)
}

#' @title Holland Wind Profile Time Series
#' @description wind profile time series at a grid point
#' @param f single coriolis parameter at the centre of TC in hz
#' @param vMax maximum wind velocity calculation in m/s
#' @param rMax radius of maximum winds in km
#' @param dP pressure differential, environmental less TC central pressure in hPa
#' @param rho density of air in Kg/m3
#' @param beta exponential term for Holland vortex
#' @param R vector of distances from grid points to TC centre in km
#' @keywords internal
#' @NoRd 
#' @return array with two columns for velocity and then vorticity.
#' //@example HollandWindProfilePi(-1e-4,20,20,10,1.15,1.2,50)
HollandWindProfilePi <- function(f, vMax, rMax, dP, rho, beta, R) {
    .Call(`_TCHazaRds_HollandWindProfilePi`, f, vMax, rMax, dP, rho, beta, R)
}

#' @title Holland Pressure Profile Time Series
#' @description Pressure profile time series at a grid point.
#' @param rMax radius of maximum winds in km
#' @param dP pressure differential, environmental less TC central pressure in hPa
#' @param cP TC central pressure in hPa
#' @param beta exponential term for Holland vortex
#' @param R vector of distances from grid points to TC centre in km
#' @keywords internal
#' @NoRd 
#' @return vector of pressures.
#' //@example HollandPressureProfilePi(20,20,980,1.2,50)
HollandPressureProfilePi <- function(rMax, dP, cP, beta, R) {
    .Call(`_TCHazaRds_HollandPressureProfilePi`, rMax, dP, cP, beta, R)
}

#' @title New Holland Wind Profile Time Series
#' @description Wind profile time series at a grid point. Holland et al. 2010.  In this version, the exponent is allowed to vary linearly outside the radius of maximum wind. I.e. rather than take the square root, the exponent varies around 0.5.Currently this version does not have a corresponding vorticity profile set up in wind Vorticity, so it cannot be applied in some wind field modelling.
#' @param f single coriolis parameter at the centre of TC in hz
#' @param rMax radius of maximum winds in km
#' @param dP pressure differential, environmental less TC central pressure in hPa
#' @param rho density of air in Kg/m3
#' @param R vector of distances from grid points to TC centre in km
#' @param vMax maximum wind velocity calculation in m/s
#' @param beta exponential term for Holland vortex
#' @keywords internal
#' @NoRd 
#' @return array with two columns for velocity and then vorticity.
#' //@example NewHollandWindProfilePi(-1e-4,20,20,1.15,-14,50,1.3)
NewHollandWindProfilePi <- function(f, rMax, dP, rho, R, vMax, beta) {
    .Call(`_TCHazaRds_NewHollandWindProfilePi`, f, rMax, dP, rho, R, vMax, beta)
}

#' @title Double Holland Wind Profile Time Series
#' @description Wind profile time series at a grid point. McConochie *et al*'s double Holland vortex model based on Cardone *et al*, 1994.This application is the Coral Sea adaptation of the double vortex model and it can also be used for concentric eye - wall configurations.
#' @param f single coriolis parameter at the centre of TC in hz
#' @param vMax maximum wind velocity calculation in m/s
#' @param rMax radius of maximum winds in km
#' @param dP pressure differential, environmental less TC central pressure in hPa
#' @param cP TC central pressure in hPa
#' @param rho density of air in Kg/m3
#' @param beta exponential term for Holland vortex
#' @param R vector of distances from grid points to TC centre in km
#' @keywords internal
#' @NoRd 
#' @return array with two columns for velocity and then vorticity.
#' //@example DoubleHollandWindProfilePi(-1e-4,20,20,10,980,1.15,1.2,50)
DoubleHollandWindProfilePi <- function(f, vMax, rMax, dP, cP, rho, beta, R) {
    .Call(`_TCHazaRds_DoubleHollandWindProfilePi`, f, vMax, rMax, dP, cP, rho, beta, R)
}

#' @title Double Holland Pressure Profile Time Series
#' @description Pressure profile time series at a grid point
#' @param rMax radius of maximum winds in km
#' @param dP pressure differential, environmental less TC central pressure in hPa
#' @param cP TC central pressure in hPa
#' @param beta exponential term for Holland vortex
#' @param R vector of distances from grid points to TC centre in km
#' @keywords internal
#' @NoRd 
#' @return vector of pressures.
#' //@example DoubleHollandPressureProfilePi(20,20,980,1.2,50)
DoubleHollandPressureProfilePi <- function(rMax, dP, cP, beta, R) {
    .Call(`_TCHazaRds_DoubleHollandPressureProfilePi`, rMax, dP, cP, beta, R)
}

#' @title Hubbert Wind Field Time Series
#' @description Time series vortex Wind, wind vectors. Hubbert, G.D., G.J.Holland, L.M.Leslie and M.J.Manton, 1991: A Real - Time System for Forecasting Tropical Cyclone Storm Surges. *Weather and Forecasting*, **6 * *, 86 - 97
#' @param f single coriolis parameter at the centre of TC in hz
#' @param rMax radius of maximum winds in km
#' @param vFm input forward velocity of TC
#' @param thetaFm input forward direction of TC
#' @param Rlam two columns for distances and direction from grid points to TC centre in km
#' @param V velocity profile
#' @keywords internal
#' @NoRd 
#' @return array with two columns for zonal and meridional wind speed vector-components.
#' //@example HubbertWindFieldPi(-1e-4,20,2,10,rbind(c(50,35),c(45,40)),c(20,20))
HubbertWindFieldPi <- function(f, rMax, vFm, thetaFm, Rlam, V) {
    .Call(`_TCHazaRds_HubbertWindFieldPi`, f, rMax, vFm, thetaFm, Rlam, V)
}

#' @title McConochie Wind Field Time Series
#' @description Time series vortex Wind, wind vectors. McConochie, J.D., T.A.Hardy and L.B.Mason, 2004: Modelling tropical cyclone over - water wind and pressure fields. Ocean Engineering, 31, 1757 - 1782.
#' @param rMax radius of maximum winds in km
#' @param vMax maximum wind velocity calculation in m/s
#' @param vFm input forward velocity of TC
#' @param thetaFm input forward direction of TC
#' @param Rlam two columns for distances and direction from grid points to TC centre in km
#' @param V velocity profile
#' @param f coriolis parameter at the centre of TC in hz
#' @keywords internal
#' @NoRd 
#' @return array with two columns for zonal and meridional wind speed vector-components.
#' //@example McConochieWindFieldPi(-1e-4,20,2,10,rbind(c(50,35),c(45,40)),c(20,20))
McConochieWindFieldPi <- function(rMax, vMax, vFm, thetaFm, Rlam, V, f) {
    .Call(`_TCHazaRds_McConochieWindFieldPi`, rMax, vMax, vFm, thetaFm, Rlam, V, f)
}

#' @title Kepert Wind Field
#' @description Time series vortex Wind, wind vectors. Kepert, J., 2001: The Dynamics of Boundary Layer Jets within the Tropical Cyclone Core.Part I : Linear Theory.J.Atmos.Sci., 58, 2469 - 2484
#' @param rMax radius of maximum winds in km
#' @param vMax maximum wind velocity calculation in m/s
#' @param vFm input forward velocity of TC
#' @param thetaFm input forward direction of TC
#' @param f single coriolis parameter at the centre of TC in hz
#' @param Rlam two columns for distances and direction from grid points to TC centre in km
#' @param VZ array two columns velocity then vorticity
#' @keywords internal
#' @NoRd 
#' @return array with two columns for zonal and meridional wind speed vector-components.
#' //@example KepertWindField(20,20,2,10,-1e-4,rbind(c(50,35),c(45,40)),rbind(c(20,2),c(22,3)))
KepertWindFieldPi <- function(rMax, vMax, vFm, thetaFm, f, Rlam, VZ) {
    .Call(`_TCHazaRds_KepertWindFieldPi`, rMax, vMax, vFm, thetaFm, f, Rlam, VZ)
}

#' @title TC Distance and Direction From Output Grid Points
#' @description Grid points distance and direction to TC.
#' @param Gridlon vector of Grid point longitudes
#' @param Gridlat vector of Grid point latitudes
#' @param TClon single TC longitude
#' @param TClat single TC latitude
#' @keywords internal
#' @NoRd 
#' @return two columns for distance in km and cartesian direction in degrees, counter clockwise from the x axis.
#' //@example Rdist(c(144,145),c(-11,-12),142,-14)
Rdist <- function(Gridlon, Gridlat, TClon, TClat) {
    .Call(`_TCHazaRds_Rdist`, Gridlon, Gridlat, TClon, TClat)
}

#' @title Jelesnianski Wind Profile
#' @description wind profile at grid points
#' @param f single coriolis parameter at the centre of TC in hz
#' @param vMax maximum wind velocity calculation in m/s
#' @param rMax radius of maximum winds in km
#' @param R vector of distances from grid points to TC centre in km
#' @keywords internal
#' @NoRd 
#' @return array with two columns for velocity and then vorticity.
#' //@example JelesnianskiWindProfile(-1e-4,20,20,50)
JelesnianskiWindProfile <- function(f, vMax, rMax, R) {
    .Call(`_TCHazaRds_JelesnianskiWindProfile`, f, vMax, rMax, R)
}

#' @title Holland Wind Profile
#' @description wind profile at grid points
#' @param f single coriolis parameter at the centre of TC in hz
#' @param vMax maximum wind velocity calculation in m/s
#' @param rMax radius of maximum winds in km
#' @param dP pressure differential, environmental less TC central pressure in hPa
#' @param rho density of air in Kg/m3
#' @param beta exponential term for Holland vortex
#' @param R vector of distances from grid points to TC centre in km
#' @keywords internal
#' @NoRd 
#' @return array with two columns for velocity and then vorticity.
#' //@example HollandWindProfile(-1e-4,20,20,10,1.15,1.2,50)
HollandWindProfile <- function(f, vMax, rMax, dP, rho, beta, R) {
    .Call(`_TCHazaRds_HollandWindProfile`, f, vMax, rMax, dP, rho, beta, R)
}

#' @title Holland Pressure Profile
#' @description Pressure profile at grid points
#' @param rMax radius of maximum winds in km
#' @param dP pressure differential, environmental less TC central pressure in hPa
#' @param cP TC central pressure in hPa
#' @param beta exponential term for Holland vortex
#' @param R vector of distances from grid points to TC centre in km
#' @keywords internal
#' @NoRd 
#' @return vector of pressures.
#' //@example HollandPressureProfile(20,20,980,1.2,50)
HollandPressureProfile <- function(rMax, dP, cP, beta, R) {
    .Call(`_TCHazaRds_HollandPressureProfile`, rMax, dP, cP, beta, R)
}

#' @title New Holland Wind Profile Time Series
#' @description Wind profile time series at a grid point. Holland et al. 2010.  In this version, the exponent is allowed to vary linearly outside the radius of maximum wind. I.e. rather than take the square root, the exponent varies around 0.5.Currently this version does not have a corresponding vorticity profile set up in wind Vorticity, so it cannot be applied in some wind field modelling.
#' @param f single coriolis parameter at the centre of TC in hz
#' @param rMax radius of maximum winds in km
#' @param dP pressure differential, environmental less TC central pressure in hPa
#' @param rho density of air in Kg/m3
#' @param R vector of distances from grid points to TC centre in km
#' @param vMax maximum wind velocity calculation in m/s
#' @param beta exponential term for Holland vortex
#' @keywords internal
#' @NoRd 
#' @return array with two columns for velocity and then vorticity.
#' //@example NewHollandWindProfile(-1e-4,20,20,1.15,-14,50,1.3)
NewHollandWindProfile <- function(f, rMax, dP, rho, R, vMax, beta) {
    .Call(`_TCHazaRds_NewHollandWindProfile`, f, rMax, dP, rho, R, vMax, beta)
}

#' @title Double Holland Wind Profile
#' @description McConochie *et al*'s double Holland vortex model based on Cardone *et al*, 1994.This application is the Coral Sea adaptation of the double vortex model and it can also be used for concentric eye - wall configurations.
#' @param f single coriolis parameter at the centre of TC in hz
#' @param vMax maximum wind velocity calculation in m/s
#' @param rMax radius of maximum winds in km
#' @param dP pressure differential, environmental less TC central pressure in hPa
#' @param cP TC central pressure in hPa
#' @param rho density of air in Kg/m3
#' @param beta exponential term for Holland vortex
#' @param R vector of distances from grid points to TC centre in km
#' @keywords internal
#' @NoRd 
#' @return array with two columns for velocity and then vorticity.
#' //@example DoubleHollandWindProfile(-1e-4,20,20,10,980,1.15,1.2,50)
DoubleHollandWindProfile <- function(f, vMax, rMax, dP, cP, rho, beta, R) {
    .Call(`_TCHazaRds_DoubleHollandWindProfile`, f, vMax, rMax, dP, cP, rho, beta, R)
}

#' @title Double Holland Pressure Profile
#' @description Pressure profile at grid points
#' @param rMax radius of maximum winds in km
#' @param dP pressure differential, environmental less TC central pressure in hPa
#' @param cP TC central pressure in hPa
#' @param beta exponential term for Holland vortex
#' @param R vector of distances from grid points to TC centre in km
#' @keywords internal
#' @NoRd 
#' @return vector of pressures.
#' //@example DoubleHollandPressureProfile(20,20,980,1.2,50)
DoubleHollandPressureProfile <- function(rMax, dP, cP, beta, R) {
    .Call(`_TCHazaRds_DoubleHollandPressureProfile`, rMax, dP, cP, beta, R)
}

#' @title Hubbert Wind Field
#' @description Grid point vortex Wind field, wind vectors. Hubbert, G.D., G.J.Holland, L.M.Leslie and M.J.Manton, 1991: A Real - Time System for Forecasting Tropical Cyclone Storm Surges. *Weather and Forecasting*, **6 * *, 86 - 97
#' @param f single coriolis parameter at the centre of TC in hz
#' @param rMax radius of maximum winds in km
#' @param vFm input forward velocity of TC
#' @param thetaFm input forward direction of TC
#' @param Rlam two columns for distances and direction from grid points to TC centre in km
#' @param V velocity profile
#' @param surface equals one if winds are reduced from the gradient level to the surface, otherwise gradient winds.
#' @keywords internal
#' @NoRd 
#' @return array with two columns for zonal and meridional wind speed vector-components.
#' //@example HubbertWindField(-1e-4,20,2,10,rbind(c(50,35),c(45,40)),c(20,20))
HubbertWindField <- function(f, rMax, vFm, thetaFm, Rlam, V, surface) {
    .Call(`_TCHazaRds_HubbertWindField`, f, rMax, vFm, thetaFm, Rlam, V, surface)
}

#' @title McConochie Wind Field
#' @description Grid point vortex Wind field, wind vectors. McConochie, J.D., T.A.Hardy and L.B.Mason, 2004: Modelling tropical cyclone over - water wind and pressure fields. Ocean Engineering, 31, 1757 - 1782.
#' @param rMax radius of maximum winds in km
#' @param vMax maximum wind velocity calculation in m/s
#' @param vFm input forward velocity of TC
#' @param thetaFm input forward direction of TC
#' @param Rlam two columns for distances and direction from grid points to TC centre in km
#' @param V velocity profile
#' @param f coriolis parameter at the centre of TC in hz
#' @param surface equals one if winds are reduced from the gradient level to the surface, otherwise gradient winds.
#' @keywords internal
#' @NoRd 
#' @return array with two columns for zonal and meridional wind speed vector-components.
#' //@example McConochieWindField(-1e-4,20,2,10,rbind(c(50,35),c(45,40)),c(20,20))
McConochieWindField <- function(rMax, vMax, vFm, thetaFm, Rlam, V, f, surface) {
    .Call(`_TCHazaRds_McConochieWindField`, rMax, vMax, vFm, thetaFm, Rlam, V, f, surface)
}

#' @title Kepert Wind Field
#' @description Grid point vortex Wind field, wind vectors. Kepert, J., 2001: The Dynamics of Boundary Layer Jets within the Tropical Cyclone Core.Part I : Linear Theory.J.Atmos.Sci., 58, 2469 - 2484
#' @param rMax radius of maximum winds in km
#' @param vMax maximum wind velocity calculation in m/s
#' @param vFm input forward velocity of TC
#' @param thetaFm input forward direction of TC
#' @param f single coriolis parameter at the centre of TC in hz
#' @param Rlam two columns for distances and Cartesian direction clocwise from the x axis from grid points to TC centre in km
#' @param VZ array two columns velocity then vorticity
#' @param surface equals one if winds are reduced from the gradient level to the surface, otherwise gradient winds.
#' @keywords internal
#' @NoRd 
#' @return array with two columns for zonal and meridional wind speed vector-components.
#' //@example KepertWindField(20,20,2,10,-1e-4,rbind(c(50,35),c(45,40)),rbind(c(20,2),c(22,3)))
KepertWindField <- function(rMax, vMax, vFm, thetaFm, f, Rlam, VZ, surface) {
    .Call(`_TCHazaRds_KepertWindField`, rMax, vMax, vFm, thetaFm, f, Rlam, VZ, surface)
}

