% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{NewHollandWindProfile}
\alias{NewHollandWindProfile}
\title{New Holland Wind Profile Time Series}
\usage{
NewHollandWindProfile(f, rMax, dP, rho, R, vMax, beta)
}
\arguments{
\item{f}{single coriolis parameter at the centre of TC in hz}

\item{rMax}{radius of maximum winds in km}

\item{dP}{pressure differential, environmental less TC central pressure in hPa}

\item{rho}{density of air in Kg/m3}

\item{R}{vector of distances from grid points to TC centre in km}

\item{vMax}{maximum wind velocity calculation in m/s}

\item{beta}{exponential term for Holland vortex}
}
\value{
array with two columns for velocity and then vorticity.
//@example NewHollandWindProfile(-1e-4,20,20,1.15,-14,50,1.3)
}
\description{
Wind profile time series at a grid point. Holland et al. 2010.  In this version, the exponent is allowed to vary linearly outside the radius of maximum wind. I.e. rather than take the square root, the exponent varies around 0.5.Currently this version does not have a corresponding vorticity profile set up in wind Vorticity, so it cannot be applied in some wind field modelling.
}
\keyword{internal}
