% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxOR.R
\name{fitSemiParamModel}
\alias{fitSemiParamModel}
\title{Fit the data using a semi-parametric model to explore
the nonlinear dose-response relationship between the
independent variable and lnOR}
\usage{
fitSemiParamModel(dataC)
}
\arguments{
\item{dataC}{Data frame containing age and binary outcome variables}
}
\value{
Fitted semi-parametric model object
}
\description{
Fit the data using a semi-parametric model to explore
the nonlinear dose-response relationship between the
independent variable and lnOR
}
\examples{
# Generate simulated data dataC
dataC <- createData(200)

# Plot the nonlinear dose-response relationship between the independent variable and lnOR
spm.fit <- fitSemiParamModel(dataC)
plot(spm.fit,ylab = "lnOR",xlab = "age",shade = FALSE)
summary(spm.fit)
}
