% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_calculations.R
\name{diagram_kernel}
\alias{diagram_kernel}
\title{Calculate persistence Fisher kernel value between a pair of persistence diagrams.}
\usage{
diagram_kernel(D1, D2, dim = 0, sigma = 1, t = 1)
}
\arguments{
\item{D1}{the first persistence diagram.}

\item{D2}{the second persistence diagram.}

\item{dim}{the non-negative integer homological dimension in which the distance is to be computed, default 0.}

\item{sigma}{a positive number representing the bandwidth for the Fisher information metric, default 1.}

\item{t}{a positive number representing the scale for the persistence Fisher kernel, default 1.}
}
\value{
the numeric kernel value.
}
\description{
Returns the persistence Fisher kernel value between a pair of persistence diagrams
in a particular homological dimension, each of which is either the output from a \code{\link{diagram_to_df}} 
function call or from a persistent homology calculation like \code{\link[TDA]{ripsDiag}}/\code{\link[TDAstats]{calculate_homology}}/\code{\link{PyH}}.
}
\details{
The persistence Fisher kernel is calculated from the Fisher information metric according to the formula
\eqn{k_{PF}(D_1,D_2) = exp(-t*d_{FIM}(D_1,D_2))}, resembling a radial basis kernel for standard
Euclidean spaces.
}
\examples{

# create two diagrams
D1 <- TDA::ripsDiag(TDA::circleUnif(n = 20,r = 1),
                    maxdimension = 1,maxscale = 2)
D2 <- TDA::ripsDiag(TDA::sphereUnif(n = 20,d = 2,r = 1),
                    maxdimension = 1,maxscale = 2)

# calculate the kernel value between D1 and D2 with sigma = 2, t = 2 in dimension 1
diagram_kernel(D1,D2,dim = 1,sigma = 2,t = 2)
# calculate the kernel value between D1 and D2 with sigma = 2, t = 2 in dimension 0
diagram_kernel(D1,D2,dim = 0,sigma = 2,t = 2)
}
\references{
Le T, Yamada M (2018). "Persistence fisher kernel: a riemannian manifold kernel for persistence diagrams." \url{https://proceedings.neurips.cc/paper/2018/file/959ab9a0695c467e7caf75431a872e5c-Paper.pdf}.

Murphy, K. "Machine learning: a probabilistic perspective", MIT press (2012).
}
\author{
Shael Brown - \email{shaelebrown@gmail.com}
}
