% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_law.R
\name{run_law}
\alias{run_law}
\title{Estimate mobility flows based on different trip distribution laws}
\usage{
run_law(
  law = "Unif",
  mass_origin,
  mass_destination = mass_origin,
  distance = NULL,
  opportunity = NULL,
  param = NULL,
  check_names = FALSE
)
}
\arguments{
\item{law}{a character indicating which law to use (see Details).}

\item{mass_origin}{a numeric vector representing the mass at origin (i.e.
demand).}

\item{mass_destination}{a numeric vector representing the mass at
destination (i.e. attractiveness).}

\item{distance}{a squared matrix representing the distance between locations
(see Details).}

\item{opportunity}{a squared matrix representing the number of opportunities
between locations (see Details). Can be easily computed with
\code{\link[=extract_opportunities]{extract_opportunities()}}.}

\item{param}{a vector of numeric value(s) used to adjust the importance of
\code{distance} or \code{opportunity} associated with the chosen law. A single value or
a vector of several parameter values can be used (see Return). Not necessary
for the original radiation law or the uniform law (see Details).}

\item{check_names}{a boolean indicating if the ID location are used as
vector names, matrix rownames and colnames and if they should be checked
(see Note).}
}
\value{
An object of class \code{TDLM}. A list of list of matrices containing for each
parameter value the matrix of probabilities (called \code{proba}). If
\code{length(param) = 1} or \code{law = "Rad"} or \verb{law = "Unif} only a list of
matrices will be returned.
}
\description{
This function estimates mobility flows using different distribution laws.
As described in \insertCite{Lenormand2016;textual}{TDLM}, we
propose a two-step approach to generate mobility flows by separating the trip
distribution law, gravity or intervening opportunities, from the modeling
approach used to generate the flows from this law. This function only uses
the first step to generate a probability distribution based on the different
laws.
}
\details{
\loadmathjax

We compute the matrix \code{proba} estimating the probability
\mjeqn{p_{ij}}{p_{ij}} to observe a trip from location \mjeqn{i}{i} to
another location \mjeqn{j}{j}
(\mjeqn{\sum_{i}\sum_{j} p_{ij}=1}{\sum_{i}\sum_{j} p_{ij}=1}). This
probability is based on the demand \mjeqn{m_{i}}{m_{i}}
(argument \code{mass_origin}) and the attractiveness
\mjeqn{m_{j}}{m_{j}} (argument \code{mass_destination}). Note that the population
is typically used as a surrogate for both quantities (this is why
\code{mass_destination = mass_origin} by default). It also depends on the
distance \mjeqn{d_{ij}}{d_{ij}} between locations (argument \code{distance}) OR
the number of opportunities \mjeqn{s_{ij}}{s_{ij}} between locations
(argument \code{opportunity}) depending on the chosen law. Both the effect of the
distance and the number of opportunities can be adjusted with a parameter
(argument \code{param}) except for the original radiation law or the uniform law.

In this package we consider eight probabilistic laws
described in details in \insertCite{Lenormand2016;textual}{TDLM}. Four
gravity laws
\insertCite{Carey1858,Zipf1946,Barthelemy2011,Lenormand2016}{TDLM}, three
intervening opportunity laws
\insertCite{Schneider1959,Simini2012,Yang2014}{TDLM} and a uniform law.
\enumerate{
\item Gravity law with an exponential distance decay function
(\code{law = "GravExp"}). The arguments \code{mass_origin}, \code{mass_destination}
(optional), \code{distance} and \code{param} will be used.
\item Normalized gravity law with an exponential distance decay function
(\code{law = "NGravExp"}). The arguments \code{mass_origin}, \code{mass_destination}
(optional), \code{distance} and \code{param} will be used.
\item Gravity law with a power distance decay function
(\code{law = "GravPow"}). The arguments \code{mass_origin}, \code{mass_destination}
(optional), \code{distance} and \code{param} will be used.
\item Normalized gravity law with a power distance decay function
(\code{law = "NGravPow"}). The arguments \code{mass_origin}, \code{mass_destination}
(optional), \code{distance} and \code{param} will be used.
\item Schneider's intervening opportunities law (\code{law = "Schneider"}). The
arguments \code{mass_origin}, \code{mass_destination} (optional), \code{opportunity} and
\code{param} will be used.
\item Radiation law (\code{law = "Rad"}). The arguments \code{mass_origin},
\code{mass_destination} (optional) and \code{opportunity} will be used.
\item Extended radiation law (\code{law = "RadExt"}). The arguments \code{mass_origin},
\code{mass_destination} (optional), \code{opportunity} and \code{param} will be used.
\item Uniform law (\code{law = "Unif"}). The argument \code{mass_origin} will be used to
extract the number of locations.
}
}
\note{
All the inputs should be based on the same number of
locations sorted in the same order. It is recommended to use the location ID
as vector names, matrix rownames and matrix colnames and to set
\code{check_names = TRUE} to verify that everything is in order before running
this function (\code{check_names = FALSE} by default). Note that the function
\code{\link[=check_format_names]{check_format_names()}} can be used to control the validity of all the inputs
before running the main package's functions.
}
\examples{
data(mass)
data(distance)

mi <- as.numeric(mass[, 1])
mj <- mi

res <- run_law(
  law = "GravExp", mass_origin = mi, mass_destination = mj,
  distance = distance, opportunity = NULL, param = 0.01,
  check_names = FALSE
)

# print(res)

}
\references{
\insertRef{Lenormand2016}{TDLM}

\insertRef{Carey1858}{TDLM}

\insertRef{Zipf1946}{TDLM}

\insertRef{Barthelemy2011}{TDLM}

\insertRef{Schneider1959}{TDLM}

\insertRef{Simini2012}{TDLM}

\insertRef{Yang2014}{TDLM}
}
\seealso{
\code{\link[=gof]{gof()}} \code{\link[=run_law_model]{run_law_model()}} \code{\link[=run_model]{run_model()}} \code{\link[=extract_opportunities]{extract_opportunities()}}
\code{\link[=check_format_names]{check_format_names()}}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
