% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.TLMoments.R
\name{summary.TLMoments}
\alias{summary.TLMoments}
\title{Summary TLMoments}
\usage{
\method{summary}{TLMoments}(object, ci.level = 0.9, ...)
}
\arguments{
\item{object}{object of TLMoments.}

\item{ci.level}{numeric vector of length 1 giving the confidence level (default is 0.9).}

\item{...}{additional arguments submitted to \code{est_cov}.}
}
\value{
A \code{summary.TLMoments}-object, a list with dimensions \itemize{
 \item \code{tlm}
 \item \code{ci.level}
 \item \code{lambda.ci}
 \item \code{lambda.cov}
 \item \code{ratio.ci}
 \item \code{ratio.cov}
}
It is printed with \code{print.summary.TLMoments}.
}
\description{
Calculating and printing of summary statistics to a given TLMoments-object.
}
\examples{
tlm <- TLMoments(rgev(100, shape = .2))
summary(tlm)

tlm <- TLMoments(rgev(100, shape = .2), rightrim = 1)
summary(tlm, select = 3:4)

tlm <- TLMoments(rgev(100, shape = .2), max.order = 2, rightrim = 1)
summary(tlm)

tlm <- TLMoments(matrix(rgev(100, shape = .2), nc = 2))
summary(tlm, select = 3:4)

tlm <- TLMoments(matrix(rgev(100, shape = .2), nc = 2), max.order = 3)
summary(tlm, ci = .95, distr = "gev")

tlm <- as.TLMoments(c(15, 5, 1.3))
summary(tlm, distr = "gev", set.n = 100)

}
\seealso{
\code{\link{TLMoments}}, \code{\link{est_cov}}
}
