% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Risoe.BINfileData2TLum.BIN.File.R
\name{Risoe.BINfileData2TLum.BIN.File}
\alias{Risoe.BINfileData2TLum.BIN.File}
\title{Convert Risoe.BINfileData object to an TLum.BIN.File object.}
\usage{
Risoe.BINfileData2TLum.BIN.File(object, relative.error)
}
\arguments{
\item{object}{\code{\linkS4class{Risoe.BINfileData}} (\bold{required}): object containing the TL curves used for the ED estimation.}

\item{relative.error}{\link{numeric} (\bold{required}): Relative error of the TL signals. Generally, it is between 0.02 and 0.1.}
}
\description{
This function convert a \linkS4class{Risoe.BINfileData} object, created using the package'Luminescence', into a TLum.BIJ.file object, which will be used by this package.
The TL package is implemented to only works with its own class of object (TLum.BIN.File, TLum.Analysis and TLum.Data.Curve).
}
\details{
This function use the data from the Risoe.BINFileData and the relative.error specified to create a absolute error matrix.
Then it create a new TLum.BIN.File including all the information from the Risoe.BINFileData and the new absolute error matrix.
For practical reason, the TLdating package considers the error as random. It means that the systematic component of the error will be ignored.
}
\author{
David Strebler, University of Cologne (Germany), \cr David Strebler
}
\seealso{
\link{TLum.BIN.File2Risoe.BINfileData}, \link{TLum.BIN.File2TLum.Analysis} and \link{TLum.BIN.File2TLum.Data.Curve}.
}

