% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_TL.SAR.R
\name{analyse_TL.SAR}
\alias{analyse_TL.SAR}
\title{SAR protocol for thermoluminescence dating}
\usage{
analyse_TL.SAR(object, eval.Tmin, eval.Tmax,
  rejection.criteria = list(recycling.ratio = 10, recuperation.rate = 10,
  testdose.error = 10, paleodose.error = 10),
  fitting.parameters = list(fit.method = "LIN", fit.weighted = FALSE,
  fit.rDoses.min = NA, fit.rDoses.max = NA),
  plotting.parameters = list(plot.Tmin = 0, plot.Tmax = NA, no.plot = FALSE))
}
\arguments{
\item{object}{\code{\linkS4class{TLum.Analysis}} (\bold{required}): object containing the TL curves used for the ED calculation.}

\item{eval.Tmin}{\link{integer} (\bold{required}): Temperature (°C) of the lowest boundary for the signal integration.}

\item{eval.Tmax}{\link{integer} (\bold{required}): Temperature (°C) of the upper boundary for the signal integration.}

\item{rejection.criteria}{\link{list} (with default): list containing the rejection criteria (in \%). See details.}

\item{fitting.parameters}{\link{list} (with default): list containing the fitting parameters. See details.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}
}
\value{
The results are plotted using \link{plot_TL.SAR}. \cr

 The function also provides an \linkS4class{TLum.Results} containing: \cr
 \describe{
   \item{\code{De.GC}}{
     \link{list}: Results obtained with the dose plateau approach and their uncertainties.
     (\code{De}, \code{De.error})}
   \item{\code{De.DP}}{
     \link{list}: Results obtained with the growth curve approach and their uncertainties.
     (\code{De}, \code{De.error})}
   \item{\code{LnLxTnTx.table}}{
     \link{matrix}: Lx/Tx values}
   \item{\code{RC.Status}}{
   \link{character}: Results of the rejection tests.
   }
 }
}
\description{
This function calculates the equivalent dose (ED) using the SAR protocol. \cr
See details for more information.
}
\details{
This function estimates the equivent dose in thermoluminescence dating using the SAR protocol.
The equivalent dose is estimated for each disc using the growth curve approaches (QC) (Aitken, 1985) and the dose plateau approach (DP).
Both approach should provide a similar result. \cr

The Lx/Tx matrix is estimated using \link{calc_TL.LxTx}. \cr
The plateau test values are estimated using \link{calc_TL.plateau}. \cr

\bold{Rejection criteria} \cr
The rejection criteria are: \cr
\describe{
 \item{\code{recycling.ratio}}{
   \link{numeric}: Maximum recycling ratio accepted (in \%).}
 \item{\code{recuperation.rate}}{
   \link{numeric}: Maximum recuperation rate accepted (in \%).}
 \item{\code{paleodose.error}}{
   \link{numeric}: Maximum error accepted on Lx (in \%).}
 \item{\code{testdose.error}}{
   \link{numeric}: Maximum error accepted on Tx (in \%).}
 }

\bold{Fitting parameters} \cr
The fitting parameters are:  \cr
\describe{
 \item{\code{method}}{
   \link{character}: Fitting method (\code{LIN}, \code{EXP}, \code{EXP+LIN} or \code{EXP+EXP}).}
 \item{\code{fit.weighted}}{
   \link{logical}: If the fitting is weighted or not.}
 \item{\code{fit.rDoses.min}}{
   \link{numeric}: lowest regenerative dose used for the fitting.}
 \item{\code{fit.rDoses.max}}{
   \link{numeric}: highest regenerative dose used for the fitting.}
}
See also \link{calc_TL.SAR.fit}. \cr

\bold{Plotting parameters} \cr
The plotting parameters are:  \cr
\describe{
 \item{\code{plot.Tmin}}{
   \link{numeric}: lowest temperature plotted.}
 \item{\code{plot.Tmax}}{
   \link{numeric}: highest temperature plotted.}
 \item{\code{no.plot}}{
   \link{logical}: If \code{TRUE}, the results will not be plotted.}
}
See also \link{plot_TL.SAR}. \cr
}
\author{
David Strebler, University of Cologne (Germany), \cr David Strebler
}
\references{
Aitken, M.J. (1985) Thermoluminescence Dating, Academic Press, London \cr

 Murray & Wintle (2000). Luminescence dating of quartz using an improved single-aliquot regenerative-dose protocol. Radiation Measurements, Vol.32, No.1, p.57-73. \cr
}
\seealso{
\link{calc_TL.LxTx},
 \link{calc_TL.plateau},
 \link{calc_TL.SAR.fit},
 \link{analyse_TL.MAAD}.
}

