% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_TL.SAR.fit.R
\name{calc_TL.SAR.fit}
\alias{calc_TL.SAR.fit}
\title{Estimation of the equivalent dose (ED) value for the SAR protocol}
\usage{
calc_TL.SAR.fit(doses, LnTn, LnTn.error, LxTx, LxTx.error,
  fitting.parameters = list(fit.method = "LIN", fit.weighted = FALSE))
}
\arguments{
\item{doses}{\link{numeric} (\bold{required}): doses vector}

\item{LnTn}{\link{numeric} (\bold{required}): Ln/Tn.}

\item{LnTn.error}{\link{numeric} (\bold{required}): Error for the Ln/Tn.}

\item{LxTx}{\link{numeric} (\bold{required}): Lx/Tx vector}

\item{LxTx.error}{\link{numeric} (\bold{required}): Error for the Lx/Tx vector}

\item{fitting.parameters}{\link{list} (with default): fitting parameters. See details.}
}
\value{
The function provides an \linkS4class{TLum.Results} object containing: \cr
 \describe{
   \item{\code{GC}}{
     \link{list}: fitting curve.}
   \item{\code{Q}}{
     \link{numeric}: equivalent dose estimation}
   \item{\code{Q.error}}{
     \link{numeric}: Error for the equivalent dose estimation}
   \item{\code{summary}}{
     \link{list}: parameters of the fitting result.}
 }
}
\description{
Internal function called by \link{analyse_TL.SAR}. \cr
This function estimates the equivalent dose (ED) based on a doses vector and a Lx/Tx vector provided. \cr
See details for more information.
}
\details{
This function estimates the equivalent dose based on the doses vector, Ln/Tn and the Lx/Tx matrix provided. \cr
Different fitting methods are available (\code{LIN}, \code{EXP}, \code{EXP+LIN} or \code{EXP+EXP}). 
Moreover, the fitting can be weigthed or not. \cr

\bold{Fitting parameters} \cr
The fitting parameters are:  \cr
\describe{
 \item{\code{method}}{
   \link{character}: Fitting method (\code{LIN}, \code{EXP}, \code{EXP+LIN} or \code{EXP+EXP}).}
 \item{\code{fit.weighted}}{
   \link{logical}: If the fitting is weighted or not.}
 \item{\code{fit.use.slope}}{
   \link{logical}: If the slope of the Q growth curve is reused for the sublinearity correction.}
 \item{\code{fit.rDoses.min}}{
   \link{numeric}: Lowest regenerative dose used for the fitting.}
 \item{\code{fit.rDoses.max}}{
   \link{numeric}: Highest regenerative dose used for the fitting.}
}
}
\author{
David Strebler, University of Cologne (Germany).
}
\seealso{
\link{analyse_TL.SAR}.
}

