% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TNRS_base.R
\name{TNRS_base}
\alias{TNRS_base}
\title{Resolve a small batch of plant taxonomic names}
\usage{
TNRS_base(
  taxonomic_names,
  sources = c("tropicos", "wcvp"),
  classification = "tropicos",
  mode = "resolve",
  matches = "best",
  accuracy = NULL,
  ...
)
}
\arguments{
\item{taxonomic_names}{Data.frame containing two columns: 1) Row number, 2) Taxonomic names to be resolved (or parsed).  Alternatively, a character vector of names can be supplied.}

\item{sources}{Character. Taxonomic sources to use. Default is c("tropicos","wcvp"). Options include "tropicos", "usda", "wfo", and "wcvp".}

\item{classification}{Character. Family classification to use. Currently options include "tropicos" (the default), which is equivalent to APGIII, and "wfo".}

\item{mode}{Character.  Options are "resolve" and "parse". Default option is "resolve"}

\item{matches}{Character. Should all matches be returned ("all") or only the best match ("best", the default)?}

\item{accuracy}{numeric.  If specified, only matches with a score greater than or equal to the supplied accuracy level will be returned.}

\item{...}{Addiitnal parameters passed to internal functions}
}
\value{
Dataframe containing TNRS results.
}
\description{
Resolve a small batch of plant taxonomic names
}
\note{
This function is primarily used as an internal function of TNRS and can only handle relatively small batches of names.

usda = United States Department of Agriculture, wfo = World Flora Online, wcvp = World Checklist of Vascular Plants.
}
\keyword{Internal}
