% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatosttwo.h.R
\name{dataTOSTtwo}
\alias{dataTOSTtwo}
\title{TOST Independent Samples T-Test}
\usage{
dataTOSTtwo(
  data,
  deps,
  group,
  var_equal = FALSE,
  hypothesis = "EQU",
  low_eqbound = -0.5,
  high_eqbound = 0.5,
  eqbound_type = "raw",
  alpha = 0.05,
  desc = FALSE,
  plots = FALSE,
  descplots = FALSE,
  low_eqbound_d = -999999999,
  high_eqbound_d = -999999999,
  smd_type = "g"
)
}
\arguments{
\item{data}{the data as a data frame}

\item{deps}{a vector of strings naming dependent variables in \code{data}}

\item{group}{a string naming the grouping variable in \code{data}; must
have two levels}

\item{var_equal}{\code{TRUE} or \code{FALSE} (default), assume equal
variances}

\item{hypothesis}{\code{'EQU'} for equivalence (default), or \code{'MET'}
for minimal effects test, the alternative hypothesis.}

\item{low_eqbound}{a number (default: -0.5) the lower equivalence/MET
bounds}

\item{high_eqbound}{a number (default: 0.5) the upper equivalence/MET
bounds}

\item{eqbound_type}{\code{'SMD'} (default) or \code{'raw'}; whether the
bounds are specified in Cohen's d or raw units respectively}

\item{alpha}{alpha level (default = 0.05)}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive
statistics}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide effect size
plots}

\item{descplots}{\code{TRUE} or \code{FALSE} (default), provide plots}

\item{low_eqbound_d}{deprecated}

\item{high_eqbound_d}{deprecated}

\item{smd_type}{\code{'d'} (default) or \code{'g'}; whether the calculated
effect size is biased (d) or bias-corrected (g).}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$text} \tab \tab \tab \tab \tab a preformatted \cr
  \code{results$tost} \tab \tab \tab \tab \tab a table \cr
  \code{results$eqb} \tab \tab \tab \tab \tab a table \cr
  \code{results$effsize} \tab \tab \tab \tab \tab a table \cr
  \code{results$desc} \tab \tab \tab \tab \tab a table \cr
  \code{results$plots} \tab \tab \tab \tab \tab an array of images \cr
  \code{results$descplots} \tab \tab \tab \tab \tab an array of images \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$tost$asDF}

\code{as.data.frame(results$tost)}
}
\description{
TOST Independent Samples T-Test
}
\section{References}{

Berger, R. L., & Hsu, J. C. (1996). Bioequivalence Trials, Intersection-Union Tests and Equivalence Confidence Sets. Statistical Science, 11(4), 283-302.

Gruman, J. A., Cribbie, R. A., & Arpin-Cribbie, C. A. (2007). The effects of heteroscedasticity on tests of equivalence. Journal of Modern Applied Statistical Methods, 6(1), 133-140, formula for Welch's t-test on page 135
}

\examples{
library(TOSTER)

## Load iris dataset, remove one of the three groups so two are left

data<-iris[which(iris$Species!="versicolor"),]

## TOST procedure on the raw data

dataTOSTtwo(data, deps="Sepal.Width", group="Species", var_equal = TRUE, low_eqbound = -0.5,
            high_eqbound = 0.5, alpha = 0.05, desc = TRUE, plots = TRUE)

}
