% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htest_helpers.R
\name{htest-helpers}
\alias{htest-helpers}
\alias{df_htest}
\alias{describe_htest}
\title{Helpers for \code{htest} objects}
\usage{
df_htest(htest, test_statistics = TRUE, show_ci = TRUE, extract_names = TRUE)

describe_htest(htest, alpha = NULL, digits = 3)
}
\arguments{
\item{htest}{A S3 object of the class \code{htest}}

\item{test_statistics}{A logical variable to display the test statistics.}

\item{show_ci}{A logical variable to display the confidence interval.}

\item{extract_names}{A logical variable to take the names from the S3 object (i.e., statistic for \code{t.test} would be "t")}

\item{alpha}{alpha level (default = 0.05)}

\item{digits}{integer indicating the number of decimal places.}
}
\description{
Functions to help interpret or display objects of the class \code{htest}
}
\examples{
# simple example with t-test
tres = t.test(extra ~ group, data = sleep)

# As a data frame
df_htest(tres)

# Describe t-test results
describe_htest(tres)

}
\seealso{
Other htest: 
\code{\link{as_htest}()},
\code{\link{simple_htest}()}
}
\concept{htest}
