% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_group.R
\name{heatmap_group}
\alias{heatmap_group}
\title{Heatmap group for visualizing grouped gene expression data.}
\usage{
heatmap_group(
  data,
  scale_data = "none",
  clust_method = "complete",
  border_show = TRUE,
  value_show = TRUE,
  low_color = "#00880088",
  mid_color = "#ffffff",
  high_color = "#ff000088",
  na_color = "#ff8800",
  x_angle = 45
)
}
\arguments{
\item{data}{Dataframe: include level1 columns (Groups, Group1, Group2, ...), level2 columns (GeneID, Sample1, Sample2, ...).}

\item{scale_data}{Character: scale data. Default: "none", options: "row", "column", "none".}

\item{clust_method}{Character: cluster method. Default: "complete", options: "ward.D", "ward.D2", "single", "complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).}

\item{border_show}{Logical: show border. Default: TRUE, options: TRUE, FALSE.}

\item{value_show}{Logical: show value in cell. Default: TRUE, options: TRUE, FALSE.}

\item{low_color}{Character: min value color (color value or hex value with alpha).}

\item{mid_color}{Character: min value color (color value or hex value with alpha).}

\item{high_color}{Character: min value color (color value or hex value with alpha).}

\item{na_color}{Character: min value color (color value or hex value with alpha).}

\item{x_angle}{Numeric: x axis text angle. Default: 45, min: 0, max: 360.}
}
\value{
Plot: Heatmap group for visualizing grouped gene expression data.
}
\description{
Heatmap group for visualizing grouped gene expression data.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(heatmap_group_data)
head(heatmap_group_data)

# 3. Default parameters
heatmap_group(heatmap_group_data)

# 4. Set scale_data = "row"
heatmap_group(heatmap_group_data, scale_data = "row")

# 5. Set border_show = TRUE
heatmap_group(heatmap_group_data, border_show = TRUE)

# 6. Set low_color = "#00008888"
heatmap_group(heatmap_group_data, low_color = "#00008888")

# 7. Set x_angle = 90
heatmap_group(heatmap_group_data, x_angle = 90)

}
\author{
benben-miao
}
