% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCorrect.R
\name{basicPF}
\alias{basicPF}
\title{Basic fitting function for stress-strain curve.}
\usage{
basicPF(x, y, subsec = NULL, lmoutput = FALSE, orderlist = NULL,
  SScurve = TRUE)
}
\arguments{
\item{x}{Numeric vector as independent variable.}

\item{y}{Numeric vector as dependent variable.}

\item{subsec}{A numeric value or vector for setting the original functions as a multi-function in
order to apply dynamic polynomial fitting one by one.}

\item{lmoutput}{A boolean value to control the output of liner models for all subsections. Default
value is FALSE.}

\item{orderlist}{An integer vector to specify maximum order for each section. Default value NULL
will use 7 in maximum for all sections.}

\item{SScurve}{A boolean value to specify whether applying overall correction. Defualt value TRUE
means not applied.}
}
\value{
A list contains independent variable and fitted dependent variable over the maximum value.
}
\description{
Basic fitting function for stress-strain curve.
}
\examples{
x <- TPMdata[,1]
y <- TPMdata[,2]

# Using 2 sections: start to x=0.3;
# x=0.3 to the end:
basicPF(x, y, subsec = 0.3)

# Using 3 sections: start to x=0.015;
# from 0.015 to 0.2; from 0.2 to the end:
basicPF(x, y, subsec = c(0.015, 0.2))

# Linear models output:
basicPF(x, y, subsec = c(0.015, 0.2), lmoutput=TRUE)
}
\keyword{internal}
