% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TSMining.R
\name{Func.SAX}
\alias{Func.SAX}
\title{A function to perform symbolic approximation aggregate (SAX) for time series data}
\usage{
Func.SAX(x, w, a, eps, norm)
}
\arguments{
\item{x}{is a numeric vector representing the univariate time series}

\item{w}{is the word size and should be an integer}

\item{a}{is the alphabet size and should be an integer}

\item{eps}{is the minimum threshold for variance in x and should be a numeric value. If x has a smaller variance than eps, it will represented as a word using the middle alphabet.}

\item{norm}{is a logical value deciding whether standardization should be applied to x. If True, x is standardized using mean and standard deviation}
}
\value{
The function returns a SAX representation of x
}
\description{
The function create SAX symbols for a univariate time series. The details of this method can be referred to J. Lin, E. Keogh, L. Wei, S. Lonardi. Experiencing SAX: a novel symbolic representation of time series
}
\examples{
x <- runif(n = 20, min = 0, max = 20)
Func.SAX(x = x, w = 5, a = 5, eps = .01, norm = TRUE)
}

